from typing import List
import ghidra.docking.settings
import ghidra.program.model.data
import ghidra.program.model.listing
import ghidra.program.model.mem
import ghidra.program.model.symbol
import ghidra.util
import java.lang
import java.net
import javax.swing.event


class FunctionDefinitionDataType(ghidra.program.model.data.GenericDataType, ghidra.program.model.data.FunctionDefinition):
    """
    Definition of a function for things like function pointers.
    """





    @overload
    def __init__(self, name: unicode): ...

    @overload
    def __init__(self, sig: ghidra.program.model.listing.FunctionSignature): ...

    @overload
    def __init__(self, function: ghidra.program.model.listing.Function, formalSignature: bool):
        """
        Create a Function Definition based on a Function
        @param function the function to use to create a Function Signature.
        @param formalSignature if true only original formal types will be retained and 
         auto-params discarded (e.g., this, __return_storage_ptr__, etc.).  If false,
         the effective signature will be used where forced indirect and auto-params
         are reflected in the signature.  This option has no affect if the specified 
         function has custom storage enabled.
        """
        ...

    @overload
    def __init__(self, path: ghidra.program.model.data.CategoryPath, name: unicode): ...

    @overload
    def __init__(self, name: unicode, dtm: ghidra.program.model.data.DataTypeManager): ...

    @overload
    def __init__(self, sig: ghidra.program.model.listing.FunctionSignature, dtm: ghidra.program.model.data.DataTypeManager): ...

    @overload
    def __init__(self, path: ghidra.program.model.data.CategoryPath, name: unicode, dtm: ghidra.program.model.data.DataTypeManager): ...

    @overload
    def __init__(self, path: ghidra.program.model.data.CategoryPath, name: unicode, sig: ghidra.program.model.listing.FunctionSignature): ...

    @overload
    def __init__(self, path: ghidra.program.model.data.CategoryPath, name: unicode, sig: ghidra.program.model.listing.FunctionSignature, dtm: ghidra.program.model.data.DataTypeManager): ...

    @overload
    def __init__(self, path: ghidra.program.model.data.CategoryPath, name: unicode, sig: ghidra.program.model.listing.FunctionSignature, universalID: ghidra.util.UniversalID, sourceArchive: ghidra.program.model.data.SourceArchive, lastChangeTime: long, lastChangeTimeInSourceArchive: long, dtm: ghidra.program.model.data.DataTypeManager): ...



    def addParent(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def clone(self, dtm: ghidra.program.model.data.DataTypeManager) -> ghidra.program.model.data.DataType: ...

    def copy(self, dtm: ghidra.program.model.data.DataTypeManager) -> ghidra.program.model.data.DataType: ...

    def dataTypeDeleted(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def dataTypeNameChanged(self, dt: ghidra.program.model.data.DataType, oldName: unicode) -> None: ...

    def dataTypeReplaced(self, oldDt: ghidra.program.model.data.DataType, newDt: ghidra.program.model.data.DataType) -> None: ...

    def dataTypeSizeChanged(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def dependsOn(self, dt: ghidra.program.model.data.DataType) -> bool: ...

    def equals(self, obj: object) -> bool: ...

    def getAlignment(self) -> int: ...

    def getArguments(self) -> List[ghidra.program.model.data.ParameterDefinition]: ...

    def getCategoryPath(self) -> ghidra.program.model.data.CategoryPath: ...

    def getClass(self) -> java.lang.Class: ...

    def getComment(self) -> unicode: ...

    def getDataOrganization(self) -> ghidra.program.model.data.DataOrganization: ...

    def getDataTypeManager(self) -> ghidra.program.model.data.DataTypeManager:
        """
        @see ghidra.program.model.data.DataType#getDataTypeManager()
        """
        ...

    def getDataTypePath(self) -> ghidra.program.model.data.DataTypePath: ...

    def getDefaultAbbreviatedLabelPrefix(self) -> unicode: ...

    @overload
    def getDefaultLabelPrefix(self) -> unicode: ...

    @overload
    def getDefaultLabelPrefix(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, len: int, options: ghidra.program.model.data.DataTypeDisplayOptions) -> unicode: ...

    def getDefaultOffcutLabelPrefix(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, len: int, options: ghidra.program.model.data.DataTypeDisplayOptions, offcutLength: int) -> unicode: ...

    def getDefaultSettings(self) -> ghidra.docking.settings.Settings: ...

    def getDescription(self) -> unicode: ...

    def getDisplayName(self) -> unicode: ...

    def getDocs(self) -> java.net.URL: ...

    def getGenericCallingConvention(self) -> ghidra.program.model.data.GenericCallingConvention: ...

    def getLastChangeTime(self) -> long: ...

    def getLastChangeTimeInSourceArchive(self) -> long: ...

    def getLength(self) -> int: ...

    def getMnemonic(self, settings: ghidra.docking.settings.Settings) -> unicode: ...

    def getName(self) -> unicode: ...

    def getParents(self) -> List[ghidra.program.model.data.DataType]: ...

    def getPathName(self) -> unicode: ...

    @overload
    def getPrototypeString(self) -> unicode: ...

    @overload
    def getPrototypeString(self, includeCallingConvention: bool) -> unicode: ...

    def getRepresentation(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, length: int) -> unicode: ...

    def getReturnType(self) -> ghidra.program.model.data.DataType: ...

    def getSettingsDefinitions(self) -> List[ghidra.docking.settings.SettingsDefinition]: ...

    def getSourceArchive(self) -> ghidra.program.model.data.SourceArchive: ...

    def getUniversalID(self) -> ghidra.util.UniversalID: ...

    def getValue(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, length: int) -> object: ...

    def getValueClass(self, settings: ghidra.docking.settings.Settings) -> java.lang.Class: ...

    def hasVarArgs(self) -> bool: ...

    def hashCode(self) -> int: ...

    def isDeleted(self) -> bool: ...

    def isDynamicallySized(self) -> bool: ...

    def isEquivalent(self, dt: ghidra.program.model.data.DataType) -> bool: ...

    def isEquivalentSignature(self, signature: ghidra.program.model.listing.FunctionSignature) -> bool: ...

    def isNotYetDefined(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def removeParent(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def replaceArgument(self, ordinal: int, newName: unicode, dt: ghidra.program.model.data.DataType, newComment: unicode, source: ghidra.program.model.symbol.SourceType) -> None: ...

    def replaceWith(self, dataType: ghidra.program.model.data.DataType) -> None: ...

    def setArguments(self, args: List[ghidra.program.model.data.ParameterDefinition]) -> None: ...

    def setCategoryPath(self, path: ghidra.program.model.data.CategoryPath) -> None: ...

    def setComment(self, comment: unicode) -> None: ...

    def setDefaultSettings(self, settings: ghidra.docking.settings.Settings) -> None: ...

    def setDescription(self, description: unicode) -> None:
        """
        Sets a String briefly describing this DataType.
         <br>If a data type that extends this class wants to allow the description to be changed,
         then it must override this method.
        @param description a one-liner describing this DataType.
        @throws UnsupportedOperationException if the description is not allowed to be set for this data type.
        """
        ...

    def setGenericCallingConvention(self, genericCallingConvention: ghidra.program.model.data.GenericCallingConvention) -> None: ...

    def setLastChangeTime(self, lastChangeTime: long) -> None: ...

    def setLastChangeTimeInSourceArchive(self, lastChangeTimeInSourceArchive: long) -> None: ...

    def setName(self, name: unicode) -> None: ...

    def setNameAndCategory(self, path: ghidra.program.model.data.CategoryPath, name: unicode) -> None: ...

    def setReturnType(self, type: ghidra.program.model.data.DataType) -> None: ...

    def setSourceArchive(self, archive: ghidra.program.model.data.SourceArchive) -> None: ...

    def setVarArgs(self, hasVarArgs: bool) -> None: ...

    def stateChanged(self, e: javax.swing.event.ChangeEvent) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def arguments(self) -> List[ghidra.program.model.data.ParameterDefinition]: ...

    @arguments.setter
    def arguments(self, value: List[ghidra.program.model.data.ParameterDefinition]) -> None: ...

    @property
    def comment(self) -> unicode: ...

    @comment.setter
    def comment(self, value: unicode) -> None: ...

    @property
    def description(self) -> unicode: ...

    @description.setter
    def description(self, value: unicode) -> None: ...

    @property
    def dynamicallySized(self) -> bool: ...

    @property
    def genericCallingConvention(self) -> ghidra.program.model.data.GenericCallingConvention: ...

    @genericCallingConvention.setter
    def genericCallingConvention(self, value: ghidra.program.model.data.GenericCallingConvention) -> None: ...

    @property
    def length(self) -> int: ...

    @property
    def prototypeString(self) -> unicode: ...

    @property
    def returnType(self) -> ghidra.program.model.data.DataType: ...

    @returnType.setter
    def returnType(self, value: ghidra.program.model.data.DataType) -> None: ...

    @property
    def varArgs(self) -> None: ...  # No getter available.

    @varArgs.setter
    def varArgs(self, value: bool) -> None: ...