from typing import List
import ghidra.docking.settings
import ghidra.program.model.data
import ghidra.program.model.mem
import ghidra.util
import java.lang
import java.net
import javax.swing.event


class UnionDataType(ghidra.program.model.data.CompositeDataTypeImpl, ghidra.program.model.data.Union):
    """
    Basic implementation of the union data type
    """





    @overload
    def __init__(self, name: unicode):
        """
        Construct a new UnionDataType
        @param name the name of this dataType
        """
        ...

    @overload
    def __init__(self, path: ghidra.program.model.data.CategoryPath, name: unicode):
        """
        Construct a new empty union with the given name within the
         specified categry path.  An empty union will report its length as 1 and 
         {@link #isNotYetDefined()} will return true.
        @param path the category path indicating where this data type is located.
        @param name the name of the new union
        """
        ...

    @overload
    def __init__(self, path: ghidra.program.model.data.CategoryPath, name: unicode, dtm: ghidra.program.model.data.DataTypeManager):
        """
        Construct a new empty union with the given name and datatype manager
         within the specified categry path.  An empty union will report its 
         length as 1 and {@link #isNotYetDefined()} will return true.
        @param path the category path indicating where this data type is located.
        @param name the name of the new union
        @param dtm the data type manager associated with this data type. This can be null. 
         Also, the data type manager may not yet contain this actual data type.
        """
        ...

    @overload
    def __init__(self, path: ghidra.program.model.data.CategoryPath, name: unicode, universalID: ghidra.util.UniversalID, sourceArchive: ghidra.program.model.data.SourceArchive, lastChangeTime: long, lastChangeTimeInSourceArchive: long, dtm: ghidra.program.model.data.DataTypeManager):
        """
        Construct a new empty union with the given name within the specified categry path.
         An empty union will report its length as 1 and {@link #isNotYetDefined()} 
         will return true.
        @param path the category path indicating where this data type is located.
        @param name the name of the new structure
        @param universalID the id for the data type
        @param sourceArchive the source archive for this data type
        @param lastChangeTime the last time this data type was changed
        @param lastChangeTimeInSourceArchive the last time this data type was changed in
         its source archive.
        @param dtm the data type manager associated with this data type. This can be null. 
         Also, the data type manager may not contain this actual data type.
        """
        ...



    @overload
    def add(self, dataType: ghidra.program.model.data.DataType) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def add(self, dataType: ghidra.program.model.data.DataType, length: int) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def add(self, dataType: ghidra.program.model.data.DataType, fieldName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def add(self, dataType: ghidra.program.model.data.DataType, length: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    def addBitField(self, baseDataType: ghidra.program.model.data.DataType, bitSize: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    def addParent(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def adjustInternalAlignment(self) -> None: ...

    def clone(self, dtm: ghidra.program.model.data.DataTypeManager) -> ghidra.program.model.data.DataType: ...

    def copy(self, dtm: ghidra.program.model.data.DataTypeManager) -> ghidra.program.model.data.DataType: ...

    def dataTypeAlignmentChanged(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def dataTypeDeleted(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def dataTypeNameChanged(self, dt: ghidra.program.model.data.DataType, oldName: unicode) -> None: ...

    def dataTypeReplaced(self, oldDt: ghidra.program.model.data.DataType, newDt: ghidra.program.model.data.DataType) -> None: ...

    def dataTypeSizeChanged(self, dt: ghidra.program.model.data.DataType) -> None: ...

    @overload
    def delete(self, ordinal: int) -> None: ...

    @overload
    def delete(self, ordinals: List[int]) -> None: ...

    def dependsOn(self, dt: ghidra.program.model.data.DataType) -> bool: ...

    def equals(self, obj: object) -> bool: ...

    def getAlignment(self) -> int: ...

    def getBitFieldPacking(self) -> ghidra.program.model.data.BitFieldPacking: ...

    def getCategoryPath(self) -> ghidra.program.model.data.CategoryPath: ...

    def getClass(self) -> java.lang.Class: ...

    def getComponent(self, ordinal: int) -> ghidra.program.model.data.DataTypeComponent: ...

    def getComponents(self) -> List[ghidra.program.model.data.DataTypeComponent]: ...

    def getDataOrganization(self) -> ghidra.program.model.data.DataOrganization: ...

    def getDataTypeManager(self) -> ghidra.program.model.data.DataTypeManager:
        """
        @see ghidra.program.model.data.DataType#getDataTypeManager()
        """
        ...

    def getDataTypePath(self) -> ghidra.program.model.data.DataTypePath: ...

    def getDefaultAbbreviatedLabelPrefix(self) -> unicode: ...

    @overload
    def getDefaultLabelPrefix(self) -> unicode: ...

    @overload
    def getDefaultLabelPrefix(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, len: int, options: ghidra.program.model.data.DataTypeDisplayOptions) -> unicode: ...

    def getDefaultOffcutLabelPrefix(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, len: int, options: ghidra.program.model.data.DataTypeDisplayOptions, offcutLength: int) -> unicode: ...

    def getDefaultSettings(self) -> ghidra.docking.settings.Settings: ...

    def getDefinedComponents(self) -> List[ghidra.program.model.data.DataTypeComponent]: ...

    def getDescription(self) -> unicode: ...

    def getDisplayName(self) -> unicode: ...

    def getDocs(self) -> java.net.URL: ...

    def getLastChangeTime(self) -> long: ...

    def getLastChangeTimeInSourceArchive(self) -> long: ...

    def getLength(self) -> int: ...

    def getMinimumAlignment(self) -> int: ...

    def getMnemonic(self, settings: ghidra.docking.settings.Settings) -> unicode: ...

    def getName(self) -> unicode: ...

    def getNumComponents(self) -> int: ...

    def getNumDefinedComponents(self) -> int: ...

    def getPackingValue(self) -> int: ...

    def getParents(self) -> List[ghidra.program.model.data.DataType]: ...

    def getPathName(self) -> unicode: ...

    def getRepresentation(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, length: int) -> unicode: ...

    def getSettingsDefinitions(self) -> List[ghidra.docking.settings.SettingsDefinition]: ...

    def getSourceArchive(self) -> ghidra.program.model.data.SourceArchive: ...

    def getUniversalID(self) -> ghidra.util.UniversalID: ...

    def getValue(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, length: int) -> object: ...

    def getValueClass(self, settings: ghidra.docking.settings.Settings) -> java.lang.Class: ...

    def hashCode(self) -> int: ...

    @overload
    def insert(self, ordinal: int, dataType: ghidra.program.model.data.DataType) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def insert(self, ordinal: int, dataType: ghidra.program.model.data.DataType, length: int) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def insert(self, ordinal: int, dataType: ghidra.program.model.data.DataType, length: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    def insertBitField(self, ordinal: int, baseDataType: ghidra.program.model.data.DataType, bitSize: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    def isDefaultAligned(self) -> bool: ...

    def isDeleted(self) -> bool: ...

    def isDynamicallySized(self) -> bool: ...

    def isEquivalent(self, dt: ghidra.program.model.data.DataType) -> bool: ...

    def isInternallyAligned(self) -> bool: ...

    def isMachineAligned(self) -> bool: ...

    def isNotYetDefined(self) -> bool: ...

    def isPartOf(self, dataTypeOfInterest: ghidra.program.model.data.DataType) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def realign(self) -> None: ...

    def removeParent(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def replaceWith(self, dataType: ghidra.program.model.data.DataType) -> None: ...

    def setCategoryPath(self, path: ghidra.program.model.data.CategoryPath) -> None: ...

    def setDefaultSettings(self, settings: ghidra.docking.settings.Settings) -> None: ...

    def setDescription(self, desc: unicode) -> None: ...

    def setInternallyAligned(self, aligned: bool) -> None: ...

    def setLastChangeTime(self, lastChangeTime: long) -> None: ...

    def setLastChangeTimeInSourceArchive(self, lastChangeTimeInSourceArchive: long) -> None: ...

    def setMinimumAlignment(self, externalAlignment: int) -> None: ...

    def setName(self, name: unicode) -> None: ...

    def setNameAndCategory(self, path: ghidra.program.model.data.CategoryPath, name: unicode) -> None: ...

    def setPackingValue(self, packingValue: int) -> None: ...

    def setSourceArchive(self, archive: ghidra.program.model.data.SourceArchive) -> None: ...

    def setToDefaultAlignment(self) -> None: ...

    def setToMachineAlignment(self) -> None: ...

    def setValue(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, length: int, value: object) -> None: ...

    def stateChanged(self, e: javax.swing.event.ChangeEvent) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def components(self) -> List[ghidra.program.model.data.DataTypeComponent]: ...

    @property
    def defaultLabelPrefix(self) -> unicode: ...

    @property
    def definedComponents(self) -> List[ghidra.program.model.data.DataTypeComponent]: ...

    @property
    def length(self) -> int: ...

    @property
    def notYetDefined(self) -> bool: ...

    @property
    def numComponents(self) -> int: ...

    @property
    def numDefinedComponents(self) -> int: ...