from typing import List
import ghidra.framework.model
import ghidra.framework.options
import ghidra.program.model.data
import ghidra.program.model.listing
import ghidra.util.task
import java.io
import java.lang
import java.util


class DataTypeArchive(ghidra.program.model.data.DataTypeManagerDomainObject, object):
    """
    This interface represents the main entry point into an object which
     stores all information relating to a single data type archive.
    """

    CREATED_WITH_GHIDRA_VERSION: unicode = u'Created With Ghidra Version'
    DATA_TYPE_ARCHIVE_INFO: unicode = u'Data Type Archive Information'
    DATA_TYPE_ARCHIVE_SETTINGS: unicode = u'Data Type Archive Settings'
    DATE_CREATED: unicode = u'Date Created'
    DO_DOMAIN_FILE_CHANGED: int = 2
    DO_OBJECT_CLOSED: int = 6
    DO_OBJECT_ERROR: int = 8
    DO_OBJECT_RENAMED: int = 3
    DO_OBJECT_RESTORED: int = 4
    DO_OBJECT_SAVED: int = 1
    DO_PROPERTY_CHANGED: int = 5
    JANUARY_1_1970: java.util.Date = Thu Jan 01 00:00:00 UTC 1970
    undoLock: object = java.lang.Object@6ff74f00







    def addCloseListener(self, __a0: ghidra.framework.model.DomainObjectClosedListener) -> None: ...

    def addConsumer(self, __a0: object) -> bool: ...

    def addListener(self, __a0: ghidra.framework.model.DomainObjectListener) -> None: ...

    def addSynchronizedDomainObject(self, __a0: ghidra.framework.model.DomainObject) -> None: ...

    def addTransactionListener(self, __a0: ghidra.framework.model.TransactionListener) -> None: ...

    def canLock(self) -> bool: ...

    def canRedo(self) -> bool: ...

    def canSave(self) -> bool: ...

    def canUndo(self) -> bool: ...

    def clearUndo(self) -> None: ...

    def createPrivateEventQueue(self, __a0: ghidra.framework.model.DomainObjectListener, __a1: int) -> ghidra.framework.model.EventQueueID: ...

    def endTransaction(self, __a0: int, __a1: bool) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def flushEvents(self) -> None: ...

    def flushPrivateEventQueue(self, __a0: ghidra.framework.model.EventQueueID) -> None: ...

    def forceLock(self, __a0: bool, __a1: unicode) -> None: ...

    def getChanges(self) -> ghidra.program.model.listing.DataTypeArchiveChangeSet:
        """
        Get the data type archive changes since the last save as a set of addresses.
        @return set of changed addresses within program.
        """
        ...

    def getClass(self) -> java.lang.Class: ...

    def getConsumerList(self) -> java.util.ArrayList: ...

    def getCreationDate(self) -> java.util.Date:
        """
        Returns the creation date of this data type archive.
         existed, then Jan 1, 1970 is returned.
        @return the creation date of this data type archive
        """
        ...

    def getCurrentTransaction(self) -> ghidra.framework.model.Transaction: ...

    def getDataTypeManager(self) -> ghidra.program.model.data.DataTypeManager: ...

    def getDefaultPointerSize(self) -> int:
        """
        Gets the default pointer size as it may be stored within the data type archive.
        @return default pointer size.
        """
        ...

    def getDescription(self) -> unicode: ...

    def getDomainFile(self) -> ghidra.framework.model.DomainFile: ...

    def getMetadata(self) -> java.util.Map: ...

    def getModificationNumber(self) -> long: ...

    def getName(self) -> unicode: ...

    def getOptions(self, __a0: unicode) -> ghidra.framework.options.Options: ...

    def getOptionsNames(self) -> List[object]: ...

    def getRedoName(self) -> unicode: ...

    def getSynchronizedDomainObjects(self) -> List[ghidra.framework.model.DomainObject]: ...

    def getUndoName(self) -> unicode: ...

    def hasExclusiveAccess(self) -> bool: ...

    def hasTerminatedTransaction(self) -> bool: ...

    def hashCode(self) -> int: ...

    def invalidate(self) -> None:
        """
        Invalidates any caching in a data type archive.
         NOTE: Over-using this method can adversely affect system performance.
        """
        ...

    def isChangeable(self) -> bool: ...

    def isChanged(self) -> bool: ...

    def isClosed(self) -> bool: ...

    def isLocked(self) -> bool: ...

    def isSendingEvents(self) -> bool: ...

    def isTemporary(self) -> bool: ...

    def isUsedBy(self, __a0: object) -> bool: ...

    def lock(self, __a0: unicode) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def redo(self) -> None: ...

    def release(self, __a0: object) -> None: ...

    def releaseSynchronizedDomainObject(self) -> None: ...

    def removeCloseListener(self, __a0: ghidra.framework.model.DomainObjectClosedListener) -> None: ...

    def removeListener(self, __a0: ghidra.framework.model.DomainObjectListener) -> None: ...

    def removePrivateEventQueue(self, __a0: ghidra.framework.model.EventQueueID) -> bool: ...

    def removeTransactionListener(self, __a0: ghidra.framework.model.TransactionListener) -> None: ...

    def save(self, __a0: unicode, __a1: ghidra.util.task.TaskMonitor) -> None: ...

    def saveToPackedFile(self, __a0: java.io.File, __a1: ghidra.util.task.TaskMonitor) -> None: ...

    def setChanged(self, type: int, oldValue: object, newValue: object) -> None:
        """
        Mark the state this data type archive as having changed and generate
         the event.  Any or all parameters may be null.
        @param type event type
        @param oldValue original value
        @param newValue new value
        """
        ...

    def setEventsEnabled(self, __a0: bool) -> None: ...

    def setName(self, __a0: unicode) -> None: ...

    def setObjChanged(self, type: int, affectedObj: object, oldValue: object, newValue: object) -> None:
        """
        Mark the state of a data type archive as having changed and generate
         the event.  Any or all parameters may be null.
        @param type event type
        @param affectedObj object that is the subject of the event
        @param oldValue original value or an Object that is related to
         the event
        @param newValue new value or an Object that is related to the
         the event
        """
        ...

    def setTemporary(self, __a0: bool) -> None: ...

    @overload
    def startTransaction(self, __a0: unicode) -> int: ...

    @overload
    def startTransaction(self, __a0: unicode, __a1: ghidra.framework.model.AbortedTransactionListener) -> int: ...

    def toString(self) -> unicode: ...

    def undo(self) -> None: ...

    def unlock(self) -> None: ...

    def updateID(self) -> None: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def changeable(self) -> bool: ...

    @property
    def changed(self) -> bool: ...

    @property
    def changes(self) -> ghidra.program.model.listing.DataTypeArchiveChangeSet: ...

    @property
    def closed(self) -> bool: ...

    @property
    def consumerList(self) -> java.util.ArrayList: ...

    @property
    def creationDate(self) -> java.util.Date: ...

    @property
    def currentTransaction(self) -> ghidra.framework.model.Transaction: ...

    @property
    def dataTypeManager(self) -> ghidra.program.model.data.DataTypeManager: ...

    @property
    def defaultPointerSize(self) -> int: ...

    @property
    def description(self) -> unicode: ...

    @property
    def domainFile(self) -> ghidra.framework.model.DomainFile: ...

    @property
    def eventsEnabled(self) -> None: ...  # No getter available.

    @eventsEnabled.setter
    def eventsEnabled(self, value: bool) -> None: ...

    @property
    def locked(self) -> bool: ...

    @property
    def metadata(self) -> java.util.Map: ...

    @property
    def modificationNumber(self) -> long: ...

    @property
    def name(self) -> unicode: ...

    @name.setter
    def name(self, value: unicode) -> None: ...

    @property
    def optionsNames(self) -> List[object]: ...

    @property
    def redoName(self) -> unicode: ...

    @property
    def sendingEvents(self) -> bool: ...

    @property
    def synchronizedDomainObjects(self) -> List[ghidra.framework.model.DomainObject]: ...

    @property
    def temporary(self) -> bool: ...

    @temporary.setter
    def temporary(self, value: bool) -> None: ...

    @property
    def undoName(self) -> unicode: ...