import ghidra.program.model.address
import ghidra.program.model.lang
import ghidra.program.model.listing
import ghidra.program.model.pcode
import ghidra.program.model.symbol
import java.lang


class InstructionPcodeOverride(object, ghidra.program.model.pcode.PcodeOverride):




    def __init__(self, instr: ghidra.program.model.listing.Instruction):
        """
        This constructor caches the primary and overriding "from" references of {@code instr}.  
         This cache is never updated; the assumption is that this object is short-lived 
         (duration of {@link PcodeEmit})
        @param instr the instruction
        """
        ...



    def equals(self, __a0: object) -> bool: ...

    def getCallFixup(self, callDestAddr: ghidra.program.model.address.Address) -> ghidra.program.model.lang.InjectPayload: ...

    def getClass(self) -> java.lang.Class: ...

    def getFallThroughOverride(self) -> ghidra.program.model.address.Address: ...

    def getFlowOverride(self) -> ghidra.program.model.listing.FlowOverride: ...

    def getInstructionStart(self) -> ghidra.program.model.address.Address: ...

    def getOverridingReference(self, type: ghidra.program.model.symbol.RefType) -> ghidra.program.model.address.Address: ...

    def getPrimaryCallReference(self) -> ghidra.program.model.address.Address: ...

    def hasCallFixup(self, callDestAddr: ghidra.program.model.address.Address) -> bool: ...

    def hasPotentialOverride(self) -> bool: ...

    def hashCode(self) -> int: ...

    def isCallOtherCallOverrideRefApplied(self) -> bool: ...

    def isCallOtherJumpOverrideApplied(self) -> bool: ...

    def isCallOverrideRefApplied(self) -> bool: ...

    def isJumpOverrideRefApplied(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def setCallOtherCallOverrideRefApplied(self) -> None: ...

    def setCallOtherJumpOverrideRefApplied(self) -> None: ...

    def setCallOverrideRefApplied(self) -> None: ...

    def setJumpOverrideRefApplied(self) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def callOtherCallOverrideRefApplied(self) -> bool: ...

    @property
    def callOtherJumpOverrideApplied(self) -> bool: ...

    @property
    def callOverrideRefApplied(self) -> bool: ...

    @property
    def fallThroughOverride(self) -> ghidra.program.model.address.Address: ...

    @property
    def flowOverride(self) -> ghidra.program.model.listing.FlowOverride: ...

    @property
    def instructionStart(self) -> ghidra.program.model.address.Address: ...

    @property
    def jumpOverrideRefApplied(self) -> bool: ...

    @property
    def primaryCallReference(self) -> ghidra.program.model.address.Address: ...