from typing import Iterator
from typing import List
import ghidra.program.model.address
import ghidra.program.model.data
import ghidra.program.model.lang
import ghidra.program.model.listing
import ghidra.program.model.mem
import ghidra.program.model.symbol
import ghidra.program.model.util
import ghidra.util.task
import java.lang


class ListingStub(object, ghidra.program.model.listing.Listing):
    """
    ListingStub can be extended for use by tests. It throws an UnsupportedOperationException
     for all methods in the Listing interface. Any method that is needed for your test can then
     be overridden so it can provide its own test implementation and return value.
    """





    def __init__(self): ...



    def addInstructions(self, instructionSet: ghidra.program.model.lang.InstructionSet, overwrite: bool) -> ghidra.program.model.address.AddressSetView: ...

    def clearAll(self, clearContext: bool, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    @overload
    def clearCodeUnits(self, startAddr: ghidra.program.model.address.Address, endAddr: ghidra.program.model.address.Address, clearContext: bool) -> None: ...

    @overload
    def clearCodeUnits(self, startAddr: ghidra.program.model.address.Address, endAddr: ghidra.program.model.address.Address, clearContext: bool, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def clearComments(self, startAddr: ghidra.program.model.address.Address, endAddr: ghidra.program.model.address.Address) -> None: ...

    def clearProperties(self, startAddr: ghidra.program.model.address.Address, endAddr: ghidra.program.model.address.Address, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    @overload
    def createData(self, addr: ghidra.program.model.address.Address, dataType: ghidra.program.model.data.DataType) -> ghidra.program.model.listing.Data: ...

    @overload
    def createData(self, addr: ghidra.program.model.address.Address, dataType: ghidra.program.model.data.DataType, length: int) -> ghidra.program.model.listing.Data: ...

    @overload
    def createFunction(self, name: unicode, entryPoint: ghidra.program.model.address.Address, body: ghidra.program.model.address.AddressSetView, source: ghidra.program.model.symbol.SourceType) -> ghidra.program.model.listing.Function: ...

    @overload
    def createFunction(self, name: unicode, nameSpace: ghidra.program.model.symbol.Namespace, entryPoint: ghidra.program.model.address.Address, body: ghidra.program.model.address.AddressSetView, source: ghidra.program.model.symbol.SourceType) -> ghidra.program.model.listing.Function: ...

    def createInstruction(self, addr: ghidra.program.model.address.Address, prototype: ghidra.program.model.lang.InstructionPrototype, memBuf: ghidra.program.model.mem.MemBuffer, context: ghidra.program.model.lang.ProcessorContextView) -> ghidra.program.model.listing.Instruction: ...

    def createRootModule(self, treeName: unicode) -> ghidra.program.model.listing.ProgramModule: ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getCodeUnitAfter(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.CodeUnit: ...

    def getCodeUnitAt(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.CodeUnit: ...

    def getCodeUnitBefore(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.CodeUnit: ...

    def getCodeUnitContaining(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.CodeUnit: ...

    @overload
    def getCodeUnitIterator(self, property: unicode, forward: bool) -> ghidra.program.model.listing.CodeUnitIterator: ...

    @overload
    def getCodeUnitIterator(self, property: unicode, addr: ghidra.program.model.address.Address, forward: bool) -> ghidra.program.model.listing.CodeUnitIterator: ...

    @overload
    def getCodeUnitIterator(self, property: unicode, addrSet: ghidra.program.model.address.AddressSetView, forward: bool) -> ghidra.program.model.listing.CodeUnitIterator: ...

    @overload
    def getCodeUnits(self, forward: bool) -> ghidra.program.model.listing.CodeUnitIterator: ...

    @overload
    def getCodeUnits(self, addr: ghidra.program.model.address.Address, forward: bool) -> ghidra.program.model.listing.CodeUnitIterator: ...

    @overload
    def getCodeUnits(self, addrSet: ghidra.program.model.address.AddressSetView, forward: bool) -> ghidra.program.model.listing.CodeUnitIterator: ...

    def getComment(self, commentType: int, address: ghidra.program.model.address.Address) -> unicode: ...

    @overload
    def getCommentAddressIterator(self, addrSet: ghidra.program.model.address.AddressSetView, forward: bool) -> ghidra.program.model.address.AddressIterator: ...

    @overload
    def getCommentAddressIterator(self, commentType: int, addrSet: ghidra.program.model.address.AddressSetView, forward: bool) -> ghidra.program.model.address.AddressIterator: ...

    def getCommentCodeUnitIterator(self, commentType: int, addrSet: ghidra.program.model.address.AddressSetView) -> ghidra.program.model.listing.CodeUnitIterator: ...

    def getCommentHistory(self, addr: ghidra.program.model.address.Address, commentType: int) -> List[ghidra.program.model.listing.CommentHistory]: ...

    @overload
    def getCompositeData(self, forward: bool) -> ghidra.program.model.listing.DataIterator: ...

    @overload
    def getCompositeData(self, start: ghidra.program.model.address.Address, forward: bool) -> ghidra.program.model.listing.DataIterator: ...

    @overload
    def getCompositeData(self, addrSet: ghidra.program.model.address.AddressSetView, forward: bool) -> ghidra.program.model.listing.DataIterator: ...

    @overload
    def getData(self, forward: bool) -> ghidra.program.model.listing.DataIterator: ...

    @overload
    def getData(self, addr: ghidra.program.model.address.Address, forward: bool) -> ghidra.program.model.listing.DataIterator: ...

    @overload
    def getData(self, addrSet: ghidra.program.model.address.AddressSetView, forward: bool) -> ghidra.program.model.listing.DataIterator: ...

    def getDataAfter(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Data: ...

    def getDataAt(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Data: ...

    def getDataBefore(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Data: ...

    def getDataContaining(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Data: ...

    def getDataTypeManager(self) -> ghidra.program.model.data.DataTypeManager: ...

    def getDefaultRootModule(self) -> ghidra.program.model.listing.ProgramModule: ...

    def getDefinedCodeUnitAfter(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.CodeUnit: ...

    def getDefinedCodeUnitBefore(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.CodeUnit: ...

    @overload
    def getDefinedData(self, forward: bool) -> ghidra.program.model.listing.DataIterator: ...

    @overload
    def getDefinedData(self, addr: ghidra.program.model.address.Address, forward: bool) -> ghidra.program.model.listing.DataIterator: ...

    @overload
    def getDefinedData(self, addrSet: ghidra.program.model.address.AddressSetView, forward: bool) -> ghidra.program.model.listing.DataIterator: ...

    def getDefinedDataAfter(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Data: ...

    def getDefinedDataAt(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Data: ...

    def getDefinedDataBefore(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Data: ...

    def getDefinedDataContaining(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Data: ...

    def getExternalFunctions(self) -> ghidra.program.model.listing.FunctionIterator: ...

    def getFirstUndefinedData(self, set: ghidra.program.model.address.AddressSetView, monitor: ghidra.util.task.TaskMonitor) -> ghidra.program.model.listing.Data: ...

    @overload
    def getFragment(self, treeName: unicode, name: unicode) -> ghidra.program.model.listing.ProgramFragment: ...

    @overload
    def getFragment(self, treeName: unicode, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.ProgramFragment: ...

    def getFunctionAt(self, entryPoint: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Function: ...

    def getFunctionContaining(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Function: ...

    @overload
    def getFunctions(self, forward: bool) -> ghidra.program.model.listing.FunctionIterator: ...

    @overload
    def getFunctions(self, start: ghidra.program.model.address.Address, forward: bool) -> ghidra.program.model.listing.FunctionIterator: ...

    @overload
    def getFunctions(self, asv: ghidra.program.model.address.AddressSetView, forward: bool) -> ghidra.program.model.listing.FunctionIterator: ...

    @overload
    def getFunctions(self, namespace: unicode, name: unicode) -> List[ghidra.program.model.listing.Function]: ...

    def getGlobalFunctions(self, name: unicode) -> List[ghidra.program.model.listing.Function]: ...

    def getInstructionAfter(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Instruction: ...

    def getInstructionAt(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Instruction: ...

    def getInstructionBefore(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Instruction: ...

    def getInstructionContaining(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Instruction: ...

    @overload
    def getInstructions(self, forward: bool) -> ghidra.program.model.listing.InstructionIterator: ...

    @overload
    def getInstructions(self, addr: ghidra.program.model.address.Address, forward: bool) -> ghidra.program.model.listing.InstructionIterator: ...

    @overload
    def getInstructions(self, addrSet: ghidra.program.model.address.AddressSetView, forward: bool) -> ghidra.program.model.listing.InstructionIterator: ...

    def getModule(self, treeName: unicode, name: unicode) -> ghidra.program.model.listing.ProgramModule: ...

    def getNumCodeUnits(self) -> long: ...

    def getNumDefinedData(self) -> long: ...

    def getNumInstructions(self) -> long: ...

    def getPropertyMap(self, propertyName: unicode) -> ghidra.program.model.util.PropertyMap: ...

    @overload
    def getRootModule(self, treeID: long) -> ghidra.program.model.listing.ProgramModule: ...

    @overload
    def getRootModule(self, treeName: unicode) -> ghidra.program.model.listing.ProgramModule: ...

    def getTreeNames(self) -> List[unicode]: ...

    def getUndefinedDataAfter(self, addr: ghidra.program.model.address.Address, monitor: ghidra.util.task.TaskMonitor) -> ghidra.program.model.listing.Data: ...

    def getUndefinedDataAt(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.listing.Data: ...

    def getUndefinedDataBefore(self, addr: ghidra.program.model.address.Address, monitor: ghidra.util.task.TaskMonitor) -> ghidra.program.model.listing.Data: ...

    def getUndefinedRanges(self, set: ghidra.program.model.address.AddressSetView, initializedMemoryOnly: bool, monitor: ghidra.util.task.TaskMonitor) -> ghidra.program.model.address.AddressSetView: ...

    def getUserDefinedProperties(self) -> Iterator[unicode]: ...

    def hashCode(self) -> int: ...

    def isInFunction(self, addr: ghidra.program.model.address.Address) -> bool: ...

    def isUndefined(self, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def removeFunction(self, entryPoint: ghidra.program.model.address.Address) -> None: ...

    def removeTree(self, treeName: unicode) -> bool: ...

    def removeUserDefinedProperty(self, propertyName: unicode) -> None: ...

    def renameTree(self, oldName: unicode, newName: unicode) -> None: ...

    def setComment(self, address: ghidra.program.model.address.Address, commentType: int, comment: unicode) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def dataTypeManager(self) -> ghidra.program.model.data.DataTypeManager: ...

    @property
    def defaultRootModule(self) -> ghidra.program.model.listing.ProgramModule: ...

    @property
    def externalFunctions(self) -> ghidra.program.model.listing.FunctionIterator: ...

    @property
    def numCodeUnits(self) -> long: ...

    @property
    def numDefinedData(self) -> long: ...

    @property
    def numInstructions(self) -> long: ...

    @property
    def treeNames(self) -> List[unicode]: ...

    @property
    def userDefinedProperties(self) -> java.util.Iterator: ...