from typing import List
import ghidra.program.model.address
import ghidra.program.model.data
import ghidra.program.model.lang
import ghidra.program.model.listing
import ghidra.program.model.pcode
import ghidra.program.model.symbol
import java.lang


class Parameter(ghidra.program.model.listing.Variable, object):
    """
    Interface for function parameters
    """

    RETURN_NAME: unicode = u'<RETURN>'
    RETURN_ORIDINAL: int = -1
    UNASSIGNED_ORDINAL: int = -2







    def compareTo(self, __a0: object) -> int: ...

    def equals(self, __a0: object) -> bool: ...

    def getAutoParameterType(self) -> ghidra.program.model.listing.AutoParameterType:
        """
        If this is an auto-parameter this method will indicate its type.
        @return auto-parameter type of null if not applicable.
        """
        ...

    def getClass(self) -> java.lang.Class: ...

    def getComment(self) -> unicode: ...

    def getDataType(self) -> ghidra.program.model.data.DataType: ...

    def getFirstStorageVarnode(self) -> ghidra.program.model.pcode.Varnode: ...

    def getFirstUseOffset(self) -> int: ...

    def getFormalDataType(self) -> ghidra.program.model.data.DataType:
        """
        Get the original formal signature data type before a possible forced indirect was
         possibly imposed by the functions calling convention.  The {@link #getDataType()} method 
         will always return the effective data type which corresponds to the allocated 
         variable storage.
        @return Formal data type.  This type will only differ from the {@link #getDataType()}
         value if this parameter isForcedIndirect.
        """
        ...

    def getFunction(self) -> ghidra.program.model.listing.Function: ...

    def getLastStorageVarnode(self) -> ghidra.program.model.pcode.Varnode: ...

    def getLength(self) -> int: ...

    def getMinAddress(self) -> ghidra.program.model.address.Address: ...

    def getName(self) -> unicode: ...

    def getOrdinal(self) -> int:
        """
        Returns the ordinal (index) of this parameter within the function signature.
        """
        ...

    def getProgram(self) -> ghidra.program.model.listing.Program: ...

    def getRegister(self) -> ghidra.program.model.lang.Register: ...

    def getRegisters(self) -> List[object]: ...

    def getSource(self) -> ghidra.program.model.symbol.SourceType: ...

    def getStackOffset(self) -> int: ...

    def getSymbol(self) -> ghidra.program.model.symbol.Symbol: ...

    def getVariableStorage(self) -> ghidra.program.model.listing.VariableStorage: ...

    def hasAssignedStorage(self) -> bool: ...

    def hasStackStorage(self) -> bool: ...

    def hashCode(self) -> int: ...

    def isAutoParameter(self) -> bool:
        """
        @return true if this parameter is automatically generated based upon the associated
         function calling convention and function signature.  An example of such a parameter 
         include the "__return_storage_ptr__" parameter.
        """
        ...

    def isCompoundVariable(self) -> bool: ...

    def isEquivalent(self, __a0: ghidra.program.model.listing.Variable) -> bool: ...

    def isForcedIndirect(self) -> bool:
        """
        If this parameter which was forced by the associated calling 
         convention to be passed as a pointer instead of its original formal type.
        @return true if this parameter was forced to be passed as a pointer instead of its 
         original formal type
        """
        ...

    def isMemoryVariable(self) -> bool: ...

    def isRegisterVariable(self) -> bool: ...

    def isStackVariable(self) -> bool: ...

    def isUniqueVariable(self) -> bool: ...

    def isValid(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def setComment(self, __a0: unicode) -> None: ...

    @overload
    def setDataType(self, __a0: ghidra.program.model.data.DataType, __a1: ghidra.program.model.symbol.SourceType) -> None: ...

    @overload
    def setDataType(self, __a0: ghidra.program.model.data.DataType, __a1: bool, __a2: bool, __a3: ghidra.program.model.symbol.SourceType) -> None: ...

    @overload
    def setDataType(self, __a0: ghidra.program.model.data.DataType, __a1: ghidra.program.model.listing.VariableStorage, __a2: bool, __a3: ghidra.program.model.symbol.SourceType) -> None: ...

    def setName(self, __a0: unicode, __a1: ghidra.program.model.symbol.SourceType) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def autoParameter(self) -> bool: ...

    @property
    def autoParameterType(self) -> ghidra.program.model.listing.AutoParameterType: ...

    @property
    def comment(self) -> unicode: ...

    @comment.setter
    def comment(self, value: unicode) -> None: ...

    @property
    def compoundVariable(self) -> bool: ...

    @property
    def dataType(self) -> ghidra.program.model.data.DataType: ...

    @property
    def firstStorageVarnode(self) -> ghidra.program.model.pcode.Varnode: ...

    @property
    def firstUseOffset(self) -> int: ...

    @property
    def forcedIndirect(self) -> bool: ...

    @property
    def formalDataType(self) -> ghidra.program.model.data.DataType: ...

    @property
    def function(self) -> ghidra.program.model.listing.Function: ...

    @property
    def lastStorageVarnode(self) -> ghidra.program.model.pcode.Varnode: ...

    @property
    def length(self) -> int: ...

    @property
    def memoryVariable(self) -> bool: ...

    @property
    def minAddress(self) -> ghidra.program.model.address.Address: ...

    @property
    def name(self) -> unicode: ...

    @property
    def ordinal(self) -> int: ...

    @property
    def program(self) -> ghidra.program.model.listing.Program: ...

    @property
    def register(self) -> ghidra.program.model.lang.Register: ...

    @property
    def registerVariable(self) -> bool: ...

    @property
    def registers(self) -> List[object]: ...

    @property
    def source(self) -> ghidra.program.model.symbol.SourceType: ...

    @property
    def stackOffset(self) -> int: ...

    @property
    def stackVariable(self) -> bool: ...

    @property
    def symbol(self) -> ghidra.program.model.symbol.Symbol: ...

    @property
    def uniqueVariable(self) -> bool: ...

    @property
    def valid(self) -> bool: ...

    @property
    def variableStorage(self) -> ghidra.program.model.listing.VariableStorage: ...