from typing import List
import ghidra.program.model.address
import ghidra.program.model.listing
import java.lang


class ProgramChangeSet(ghidra.program.model.listing.DomainObjectChangeSet, ghidra.program.model.listing.AddressChangeSet, ghidra.program.model.listing.RegisterChangeSet, ghidra.program.model.listing.DataTypeChangeSet, ghidra.program.model.listing.ProgramTreeChangeSet, ghidra.program.model.listing.SymbolChangeSet, ghidra.program.model.listing.FunctionTagChangeSet, object):
    """
    Interface for a Program Change set.  Objects that implements this interface track
     various change information on a program.
    """









    def add(self, __a0: ghidra.program.model.address.AddressSetView) -> None: ...

    def addRange(self, __a0: ghidra.program.model.address.Address, __a1: ghidra.program.model.address.Address) -> None: ...

    def addRegisterRange(self, __a0: ghidra.program.model.address.Address, __a1: ghidra.program.model.address.Address) -> None: ...

    def categoryAdded(self, __a0: long) -> None: ...

    def categoryChanged(self, __a0: long) -> None: ...

    def dataTypeAdded(self, __a0: long) -> None: ...

    def dataTypeChanged(self, __a0: long) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getAddressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    def getAddressSetCollectionSinceCheckout(self) -> ghidra.program.model.address.AddressSetCollection:
        """
        Gets an AddressSetCollection which contains the addressSets that track all the addresses
         where changes have occurred since the file was checked out. If the file is not versioned,
         this AddressSetCollection will be empty.
        @return AddressSetCollection containing all addresses that changed since the program was checked out.
        """
        ...

    def getAddressSetCollectionSinceLastSave(self) -> ghidra.program.model.address.AddressSetCollection:
        """
        Gets an AddressSetCollection which contains the addressSets that track all the addresses
         where changes have occurred since the last save.
        @return AddressSetCollection containing all addresses that changed since the last save.
        """
        ...

    def getCategoryAdditions(self) -> List[long]: ...

    def getCategoryChanges(self) -> List[long]: ...

    def getClass(self) -> java.lang.Class: ...

    def getDataTypeAdditions(self) -> List[long]: ...

    def getDataTypeChanges(self) -> List[long]: ...

    def getProgramTreeAdditions(self) -> List[long]: ...

    def getProgramTreeChanges(self) -> List[long]: ...

    def getRegisterAddressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    def getSourceArchiveAdditions(self) -> List[long]: ...

    def getSourceArchiveChanges(self) -> List[long]: ...

    def getSymbolAdditions(self) -> List[long]: ...

    def getSymbolChanges(self) -> List[long]: ...

    def getTagChanges(self) -> List[long]: ...

    def getTagCreations(self) -> List[long]: ...

    def hasChanges(self) -> bool: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def programTreeAdded(self, __a0: long) -> None: ...

    def programTreeChanged(self, __a0: long) -> None: ...

    def sourceArchiveAdded(self, __a0: long) -> None: ...

    def sourceArchiveChanged(self, __a0: long) -> None: ...

    def symbolAdded(self, __a0: long) -> None: ...

    def symbolChanged(self, __a0: long) -> None: ...

    def tagChanged(self, __a0: long) -> None: ...

    def tagCreated(self, __a0: long) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def addressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    @property
    def addressSetCollectionSinceCheckout(self) -> ghidra.program.model.address.AddressSetCollection: ...

    @property
    def addressSetCollectionSinceLastSave(self) -> ghidra.program.model.address.AddressSetCollection: ...

    @property
    def categoryAdditions(self) -> List[long]: ...

    @property
    def categoryChanges(self) -> List[long]: ...

    @property
    def dataTypeAdditions(self) -> List[long]: ...

    @property
    def dataTypeChanges(self) -> List[long]: ...

    @property
    def programTreeAdditions(self) -> List[long]: ...

    @property
    def programTreeChanges(self) -> List[long]: ...

    @property
    def registerAddressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    @property
    def sourceArchiveAdditions(self) -> List[long]: ...

    @property
    def sourceArchiveChanges(self) -> List[long]: ...

    @property
    def symbolAdditions(self) -> List[long]: ...

    @property
    def symbolChanges(self) -> List[long]: ...

    @property
    def tagChanges(self) -> List[long]: ...

    @property
    def tagCreations(self) -> List[long]: ...