from typing import List
import ghidra.program.model.address
import ghidra.program.model.mem
import java.lang


class DumbMemBufferImpl(ghidra.program.model.mem.MemoryBufferImpl):
    """
    DumbMemBufferImpl extends MemoryBufferImpl
     with an internal cache buffer size of 16-bytes but will use the underlying memory
     if needed.
    """





    def __init__(self, mem: ghidra.program.model.mem.Memory, addr: ghidra.program.model.address.Address):
        """
        Construct a new DumbMemBufferImpl
        @param mem memory associated with the given address
        @param addr starting address
        """
        ...



    def advance(self, displacement: int) -> None: ...

    def clone(self) -> ghidra.program.model.mem.MemoryBufferImpl: ...

    def equals(self, __a0: object) -> bool: ...

    def getAddress(self) -> ghidra.program.model.address.Address: ...

    def getBigInteger(self, offset: int, size: int, signed: bool) -> long: ...

    def getByte(self, offset: int) -> int: ...

    def getBytes(self, b: List[int], offset: int) -> int: ...

    def getClass(self) -> java.lang.Class: ...

    def getInt(self, offset: int) -> int: ...

    def getLong(self, offset: int) -> long: ...

    def getMemory(self) -> ghidra.program.model.mem.Memory: ...

    def getShort(self, offset: int) -> int: ...

    def getUnsignedByte(self, __a0: int) -> int: ...

    def getUnsignedInt(self, __a0: int) -> long: ...

    def getUnsignedShort(self, __a0: int) -> int: ...

    def getVarLengthInt(self, __a0: int, __a1: int) -> int: ...

    def getVarLengthUnsignedInt(self, __a0: int, __a1: int) -> long: ...

    def hashCode(self) -> int: ...

    def isBigEndian(self) -> bool: ...

    def isInitializedMemory(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def setPosition(self, addr: ghidra.program.model.address.Address) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

