import ghidra.program.model.address
import ghidra.program.model.listing
import ghidra.program.model.pcode
import ghidra.xml
import java.lang


class DynamicEntry(ghidra.program.model.pcode.SymbolEntry):
    """
    A HighSymbol mapping based on local hashing of the symbol's Varnode within a
     function's syntax tree.  The storage address of a temporary Varnode (a Varnode in
     the "unique" address space) is too ephemeral to use as a permanent way to identify it.
     This symbol stores a hash (generated by DynamicHash) that is better suited to
     identifying the Varnode.
    """





    @overload
    def __init__(self, sym: ghidra.program.model.pcode.HighSymbol):
        """
        Constructor for use with restoreXML
        @param sym is the owning HighSymbol
        """
        ...

    @overload
    def __init__(self, sym: ghidra.program.model.pcode.HighSymbol, addr: ghidra.program.model.address.Address, h: long):
        """
        Construct given the underlying symbol, defining Address of the Varnode, and the hash value
        @param sym is the given symbol
        @param addr is the defining Address
        @param h is the hash value
        """
        ...



    @staticmethod
    def build(vn: ghidra.program.model.pcode.Varnode) -> ghidra.program.model.pcode.DynamicEntry:
        """
        Build a new DynamicEntry, given the underlying temporary
         Varnode attached to a symbol.  The hash is created from local information in the
         syntax tree near the Varnode.
        @param vn is the underlying Varnode
        @return the new DynamicEntry
        """
        ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getHash(self) -> long:
        """
        @return the hash value
        """
        ...

    def getPCAdress(self) -> ghidra.program.model.address.Address:
        """
        The storage used to hold this Symbol may be used for other purposes at different points in
         the code.  This returns the earliest address in the code where this storage is used for this symbol
        @return the starting address where the Symbol uses this storage
        """
        ...

    def getSize(self) -> int: ...

    def getStorage(self) -> ghidra.program.model.listing.VariableStorage: ...

    def hashCode(self) -> int: ...

    def isReadOnly(self) -> bool: ...

    def isVolatile(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def restoreXML(self, parser: ghidra.xml.XmlPullParser) -> None: ...

    def saveXml(self, buf: java.lang.StringBuilder) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def hash(self) -> long: ...

    @property
    def readOnly(self) -> bool: ...

    @property
    def size(self) -> int: ...

    @property
    def storage(self) -> ghidra.program.model.listing.VariableStorage: ...

    @property
    def volatile(self) -> bool: ...