from typing import List
import ghidra.program.model.address
import ghidra.program.model.listing
import ghidra.program.model.pcode
import ghidra.program.model.pcode.JumpTable
import ghidra.program.model.symbol
import ghidra.xml
import java.lang


class JumpTable(object):
    """
    JumpTable found as part of the decompilation of a function
    """






    class LoadTable(object):








        def equals(self, __a0: object) -> bool: ...

        def getAddress(self) -> ghidra.program.model.address.Address: ...

        def getClass(self) -> java.lang.Class: ...

        def getNum(self) -> int: ...

        def getSize(self) -> int: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def restoreXml(self, __a0: ghidra.xml.XmlPullParser, __a1: ghidra.program.model.address.AddressFactory) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def address(self) -> ghidra.program.model.address.Address: ...

        @property
        def num(self) -> int: ...

        @property
        def size(self) -> int: ...




    class BasicOverride(object):




        def __init__(self, __a0: ghidra.program.model.pcode.JumpTable, __a1: java.util.ArrayList): ...



        def buildXml(self, __a0: java.lang.StringBuilder) -> None: ...

        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDestinations(self) -> List[ghidra.program.model.address.Address]: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def destinations(self) -> List[ghidra.program.model.address.Address]: ...

    @overload
    def __init__(self, preferredSpace: ghidra.program.model.address.AddressSpace): ...

    @overload
    def __init__(self, __a0: ghidra.program.model.address.Address, __a1: java.util.ArrayList, __a2: bool): ...



    def buildXml(self, buf: java.lang.StringBuilder) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getCases(self) -> List[ghidra.program.model.address.Address]: ...

    def getClass(self) -> java.lang.Class: ...

    def getLabelValues(self) -> List[int]: ...

    def getLoadTables(self) -> List[ghidra.program.model.pcode.JumpTable.LoadTable]: ...

    def getSwitchAddress(self) -> ghidra.program.model.address.Address: ...

    def hashCode(self) -> int: ...

    def isEmpty(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    @staticmethod
    def readOverride(space: ghidra.program.model.symbol.Namespace, symtab: ghidra.program.model.symbol.SymbolTable) -> ghidra.program.model.pcode.JumpTable: ...

    def restoreXml(self, parser: ghidra.xml.XmlPullParser, addrFactory: ghidra.program.model.address.AddressFactory) -> None:
        """
        Create a JumpTable object by parsing the XML elements
        @param parser
        @param addrFactory
        @throws PcodeXMLException
        """
        ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    def writeOverride(self, func: ghidra.program.model.listing.Function) -> None: ...

    @property
    def cases(self) -> List[ghidra.program.model.address.Address]: ...

    @property
    def empty(self) -> bool: ...

    @property
    def labelValues(self) -> List[int]: ...

    @property
    def loadTables(self) -> List[ghidra.program.model.pcode.JumpTable.LoadTable]: ...

    @property
    def switchAddress(self) -> ghidra.program.model.address.Address: ...