import ghidra.framework.model
import java.lang


class DataTypeArchiveChangeRecord(ghidra.framework.model.DomainObjectChangeRecord):
    """
    Event data for a DomainObjectChangeEvent generated by a Data Type Archive.
     See Data Type Archive Events for more
     information on event data.

    """





    def __init__(self, type: int, affectedObj: object, oldValue: object, newValue: object):
        """
        Construct a new DataTypeArchiveChangeRecord; 
         the <code>affectedObj</code> parameter may be null, 
         depending on what the <code>type</code> parameter is.
        @param type event type
        @param affectedObj the object affected by the change
        @param oldValue original value
        @param newValue new value
        """
        ...



    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getEventType(self) -> int:
        """
        Return the event type for this change record.
        """
        ...

    def getNewValue(self) -> object:
        """
        Return the new value.
        """
        ...

    def getObject(self) -> object:
        """
        Return the object that is the subject of this change record.
        @return Object null if this change record does not have the
         affected object
        """
        ...

    def getOldValue(self) -> object:
        """
        Return the old value.
        """
        ...

    def getSubEventType(self) -> int:
        """
        Return the sub-event type for this change record.
         A value of 0 is the default if unspecified.
        """
        ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def object(self) -> object: ...