import ghidra.framework.model
import ghidra.program.model.address
import java.lang


class ProgramChangeRecord(ghidra.framework.model.DomainObjectChangeRecord):
    """
    Event data for a DomainObjectChangeEvent generated by a Program.
     See Program Events for more
     information on event data.

    """





    @overload
    def __init__(self, type: int, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address, affectedObj: object, oldValue: object, newValue: object):
        """
        Construct a new ProgramChangeRecord; any of the Address or
         Object params may be null, depending on what the type param is.
        @param type event type
        @param start starting address that is affected by the event
        @param end ending address that is affected by the event
        @param oldValue original value
        @param newValue new value
        """
        ...

    @overload
    def __init__(self, type: int, subType: int, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address, affectedObj: object, oldValue: object, newValue: object):
        """
        Construct a new ProgramChangeRecord; any of the Address or
         Object params may be null, depending on what the type param is.
        @param type event type
        @param subType event sub-type
        @param start starting address that is affected by the event
        @param end ending address that is affected by the event
        @param oldValue original value
        @param newValue new value
        """
        ...



    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getEnd(self) -> ghidra.program.model.address.Address:
        """
        Get the end address.
        """
        ...

    def getEventType(self) -> int:
        """
        Return the event type for this change record.
        """
        ...

    def getNewValue(self) -> object:
        """
        Return the new value.
        """
        ...

    def getObject(self) -> object:
        """
        Return the object that is the subject of this change record.
        @return Object null if this change record does not have the
         affected object
        """
        ...

    def getOldValue(self) -> object:
        """
        Return the old value.
        """
        ...

    def getStart(self) -> ghidra.program.model.address.Address:
        """
        Get the start address.
        """
        ...

    def getSubEventType(self) -> int:
        """
        Return the sub-event type for this change record.
         A value of 0 is the default if unspecified.
        """
        ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def end(self) -> ghidra.program.model.address.Address: ...

    @property
    def object(self) -> object: ...

    @property
    def start(self) -> ghidra.program.model.address.Address: ...