from typing import List
import ghidra.app.plugin
import ghidra.app.plugin.core.console
import ghidra.app.plugin.core.interpreter
import ghidra.framework.model
import ghidra.framework.options
import ghidra.framework.plugintool
import ghidra.framework.plugintool.util
import ghidra.program.model.listing
import ghidra.program.util
import java.lang
import javax.swing


class PythonPlugin(ghidra.app.plugin.ProgramPlugin, ghidra.app.plugin.core.interpreter.InterpreterConnection, ghidra.framework.options.OptionsChangeListener):
    """
    This plugin provides the interactive Python interpreter.
    """





    def __init__(self, tool: ghidra.framework.plugintool.PluginTool):
        """
        Creates a new PythonPlugin object.
        @param tool The tool associated with this plugin.
        """
        ...



    def acceptData(self, __a0: List[ghidra.framework.model.DomainFile]) -> bool: ...

    def dataStateRestoreCompleted(self) -> None: ...

    def dependsUpon(self, __a0: ghidra.framework.plugintool.Plugin) -> bool: ...

    def equals(self, __a0: object) -> bool: ...

    def eventSent(self, __a0: ghidra.framework.plugintool.PluginEvent) -> None: ...

    def firePluginEvent(self, __a0: ghidra.framework.plugintool.PluginEvent) -> None: ...

    def getClass(self) -> java.lang.Class: ...

    def getCompletions(self, cmd: unicode) -> List[ghidra.app.plugin.core.console.CodeCompletion]:
        """
        Returns a list of possible command completion values.
        @param cmd current command line (without prompt)
        @return A list of possible command completion values.  Could be empty if there aren't any.
        """
        ...

    def getCurrentProgram(self) -> ghidra.program.model.listing.Program: ...

    def getData(self) -> List[ghidra.framework.model.DomainFile]: ...

    def getIcon(self) -> javax.swing.ImageIcon: ...

    def getMissingRequiredServices(self) -> List[object]: ...

    def getName(self) -> unicode: ...

    def getPluginDescription(self) -> ghidra.framework.plugintool.util.PluginDescription: ...

    @staticmethod
    def getPluginName(__a0: java.lang.Class) -> unicode: ...

    def getProgramHighlight(self) -> ghidra.program.util.ProgramSelection: ...

    def getProgramLocation(self) -> ghidra.program.util.ProgramLocation: ...

    def getProgramSelection(self) -> ghidra.program.util.ProgramSelection: ...

    def getSupportedDataTypes(self) -> List[java.lang.Class]: ...

    def getTitle(self) -> unicode: ...

    def getTool(self) -> ghidra.framework.plugintool.PluginTool: ...

    def getTransientState(self) -> object: ...

    def getUndoRedoState(self, __a0: ghidra.framework.model.DomainObject) -> object: ...

    def hasMissingRequiredService(self) -> bool: ...

    def hashCode(self) -> int: ...

    def interrupt(self) -> None:
        """
        Interrupts what the interpreter is currently doing.
        """
        ...

    def isDisposed(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def optionsChanged(self, options: ghidra.framework.options.ToolOptions, optionName: unicode, oldValue: object, newValue: object) -> None:
        """
        Handle a change in one of our options.
        @param options the options handle
        @param optionName name of the option changed
        @param oldValue the old value
        @param newValue the new value
        """
        ...

    def processEvent(self, __a0: ghidra.framework.plugintool.PluginEvent) -> None: ...

    def readConfigState(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    def readDataState(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    def reset(self) -> None:
        """
        Resets the interpreter's state.
        """
        ...

    def restoreTransientState(self, __a0: object) -> None: ...

    def restoreUndoRedoState(self, __a0: ghidra.framework.model.DomainObject, __a1: object) -> None: ...

    def serviceAdded(self, __a0: java.lang.Class, __a1: object) -> None: ...

    def serviceRemoved(self, __a0: java.lang.Class, __a1: object) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    def writeConfigState(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    def writeDataState(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    @property
    def icon(self) -> javax.swing.ImageIcon: ...

    @property
    def title(self) -> unicode: ...