import ghidra.app.plugin.core.searchmem
import ghidra.program.model.address
import ghidra.program.model.listing
import ghidra.program.util
import ghidra.util.search.memory
import ghidra.util.task
import java.lang


class SearchInfo(object):




    @overload
    def __init__(self, searchData: ghidra.app.plugin.core.searchmem.SearchData, matchLimit: int, searchSelection: bool, forwardSearch: bool, alignment: int, includeNonLoadedBlocks: bool, listener: ghidra.util.task.TaskListener): ...

    @overload
    def __init__(self, searchData: ghidra.app.plugin.core.searchmem.SearchData, matchLimit: int, searchSelection: bool, forwardSearch: bool, alignment: int, includeNonLoadedBlocks: bool, codeUnitSearchInfo: ghidra.util.search.memory.CodeUnitSearchInfo, listener: ghidra.util.task.TaskListener): ...



    def createSearchAlgorithm(self, p: ghidra.program.model.listing.Program, start: ghidra.program.model.address.Address, selection: ghidra.program.util.ProgramSelection) -> ghidra.util.search.memory.MemorySearchAlgorithm: ...

    def equals(self, __a0: object) -> bool: ...

    def getAlignment(self) -> int: ...

    def getClass(self) -> java.lang.Class: ...

    def getCodeUnitSearchInfo(self) -> ghidra.util.search.memory.CodeUnitSearchInfo: ...

    def getListener(self) -> ghidra.util.task.TaskListener: ...

    def getMatchLimit(self) -> int: ...

    def getSearchData(self) -> ghidra.app.plugin.core.searchmem.SearchData: ...

    def getSearchLimit(self) -> int: ...

    def hashCode(self) -> int: ...

    def isSearchAll(self) -> bool: ...

    def isSearchForward(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def alignment(self) -> int: ...

    @property
    def codeUnitSearchInfo(self) -> ghidra.util.search.memory.CodeUnitSearchInfo: ...

    @property
    def listener(self) -> ghidra.util.task.TaskListener: ...

    @property
    def matchLimit(self) -> int: ...

    @property
    def searchAll(self) -> bool: ...

    @property
    def searchData(self) -> ghidra.app.plugin.core.searchmem.SearchData: ...

    @property
    def searchForward(self) -> bool: ...

    @property
    def searchLimit(self) -> int: ...