import ghidra.util.task
import java.lang


class BasicTaskMonitor(object, ghidra.util.task.TaskMonitor):
    """
    A task monitor that tracks all monitor state, but is not attached to any UI component
 
     Synchronization Policy:
     We wish for this class to be performant.    Thus, we do not synchronize the methods of this
     class, nor do we make the values thread visible via volatile or by any of 
     the Java concurrent structures (e.g., AtomicBoolean).   In order to keep the values of
     this class's fields update-to-date, we have chosen to synchronize the package-level client of
     this class.  If this class is ever made public, then most of the methods herein need to 
     be synchronized to prevent race conditions and to provide visibility.
    """









    def addCancelledListener(self, l: ghidra.util.task.CancelledListener) -> None: ...

    def cancel(self) -> None: ...

    def checkCanceled(self) -> None: ...

    def clearCanceled(self) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getMaximum(self) -> long: ...

    def getMessage(self) -> unicode: ...

    def getProgress(self) -> long: ...

    def hashCode(self) -> int: ...

    def incrementProgress(self, incrementAmount: long) -> None: ...

    def initialize(self, maxValue: long) -> None: ...

    def isCancelEnabled(self) -> bool: ...

    def isCancelled(self) -> bool: ...

    def isIndeterminate(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def removeCancelledListener(self, l: ghidra.util.task.CancelledListener) -> None: ...

    def setCancelEnabled(self, enable: bool) -> None: ...

    def setIndeterminate(self, indeterminate: bool) -> None: ...

    def setMaximum(self, max: long) -> None: ...

    def setMessage(self, message: unicode) -> None: ...

    def setProgress(self, value: long) -> None: ...

    def setShowProgressValue(self, showProgressValue: bool) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

