import ghidra.util.task
import java.lang


class CancelOnlyWrappingTaskMonitor(ghidra.util.task.WrappingTaskMonitor):
    """
    A monitor that is designed for sub-tasks, where the outer task handles reporting messages and
     progress.  This class is really just for checking cancelled.
 
     This class wants the following methods related to cancelling to work normally:
 
      isCancelled()
    	checkCanceled()
    	cancel()
    	addCancelledListener(CancelledListener)
    	removeCancelledListener(CancelledListener)
    	addIssueListener(IssueListener)
    	removeIssueListener(IssueListener)
    	isCancelEnabled()
			

    	The rest of TaskMonitor should be stubbed out.  This means that if any methods are 
    	added to the TaskMonitor interface, and subsequently implemented in this class's parent,
    	then this class needs to override them.
    """





    def __init__(self, delegate: ghidra.util.task.TaskMonitor): ...



    def addCancelledListener(self, listener: ghidra.util.task.CancelledListener) -> None: ...

    def cancel(self) -> None: ...

    def checkCanceled(self) -> None: ...

    def clearCanceled(self) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getMaximum(self) -> long: ...

    def getMessage(self) -> unicode: ...

    def getProgress(self) -> long: ...

    def hashCode(self) -> int: ...

    def incrementProgress(self, incrementAmount: long) -> None: ...

    def initialize(self, max: long) -> None: ...

    def isCancelEnabled(self) -> bool: ...

    def isCancelled(self) -> bool: ...

    def isIndeterminate(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def removeCancelledListener(self, listener: ghidra.util.task.CancelledListener) -> None: ...

    def setCancelEnabled(self, enable: bool) -> None: ...

    def setDelegate(self, newDelegate: ghidra.util.task.TaskMonitor) -> None:
        """
        Sets the delegate of this wrapper to be the new value.  The new delegate will be 
         initialized with the current values of the existing delegate.
        @param newDelegate the new delegate
        """
        ...

    def setIndeterminate(self, indeterminate: bool) -> None: ...

    def setMaximum(self, max: long) -> None: ...

    def setMessage(self, message: unicode) -> None: ...

    def setProgress(self, value: long) -> None: ...

    def setShowProgressValue(self, showProgressValue: bool) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def cancelEnabled(self) -> bool: ...

    @cancelEnabled.setter
    def cancelEnabled(self, value: bool) -> None: ...

    @property
    def indeterminate(self) -> bool: ...

    @indeterminate.setter
    def indeterminate(self, value: bool) -> None: ...

    @property
    def maximum(self) -> long: ...

    @maximum.setter
    def maximum(self, value: long) -> None: ...

    @property
    def message(self) -> unicode: ...

    @message.setter
    def message(self, value: unicode) -> None: ...

    @property
    def progress(self) -> long: ...

    @progress.setter
    def progress(self, value: long) -> None: ...

    @property
    def showProgressValue(self) -> None: ...  # No getter available.

    @showProgressValue.setter
    def showProgressValue(self, value: bool) -> None: ...