# Generated by Django 3.0 on 2022-01-25 16:02

import _utils.models
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="RP",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                ("text", models.CharField(max_length=200)),
                ("html", models.CharField(max_length=600)),
            ],
            bases=(_utils.models.QualifiedIDMixin, models.Model),
        ),
        migrations.CreateModel(
            name="Species",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                ("text", models.CharField(max_length=80)),
                ("html", models.CharField(max_length=200)),
                ("charge", models.SmallIntegerField(default=0, null=True)),
            ],
            bases=(_utils.models.QualifiedIDMixin, models.Model),
        ),
        migrations.CreateModel(
            name="State",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "state_type",
                    models.SmallIntegerField(
                        choices=[
                            (0, "KeyValuePair"),
                            (1, "GenericExcitedState"),
                            (2, "AtomicConfiguration"),
                            (3, "AtomicTermSymbol"),
                            (4, "DiatomicMolecularConfiguration"),
                            (5, "MolecularTermSymbol"),
                            (6, "VibrationalState"),
                            (10, "RotationalState"),
                            (11, "RacahSymbol"),
                        ]
                    ),
                ),
                ("text", models.CharField(max_length=64)),
                ("html", models.CharField(max_length=100)),
                (
                    "rp",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="rp.RP"
                    ),
                ),
            ],
            bases=(_utils.models.QualifiedIDMixin, models.Model),
        ),
        migrations.AddField(
            model_name="rp",
            name="species",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="rp.Species"
            ),
        ),
    ]
