import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudMongoUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * The id of your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#cluster_id DataIonoscloudMongoUser#cluster_id}
    */
    readonly clusterId: string;
    /**
    * The database
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#database DataIonoscloudMongoUser#database}
    */
    readonly database?: string;
    /**
    * Id of the backup unit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#id DataIonoscloudMongoUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The username to search for
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#username DataIonoscloudMongoUser#username}
    */
    readonly username: string;
    /**
    * roles block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#roles DataIonoscloudMongoUser#roles}
    */
    readonly roles?: DataIonoscloudMongoUserRoles[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#timeouts DataIonoscloudMongoUser#timeouts}
    */
    readonly timeouts?: DataIonoscloudMongoUserTimeouts;
}
export interface DataIonoscloudMongoUserRoles {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#database DataIonoscloudMongoUser#database}
    */
    readonly database?: string;
    /**
    * A list of mongodb user roles. Examples: read, readWrite, readAnyDatabase
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#role DataIonoscloudMongoUser#role}
    */
    readonly role?: string;
}
export declare function dataIonoscloudMongoUserRolesToTerraform(struct?: DataIonoscloudMongoUserRoles | cdktf.IResolvable): any;
export declare class DataIonoscloudMongoUserRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudMongoUserRoles | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudMongoUserRoles | cdktf.IResolvable | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
}
export declare class DataIonoscloudMongoUserRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataIonoscloudMongoUserRoles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudMongoUserRolesOutputReference;
}
export interface DataIonoscloudMongoUserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#create DataIonoscloudMongoUser#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#default DataIonoscloudMongoUser#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#delete DataIonoscloudMongoUser#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user#update DataIonoscloudMongoUser#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudMongoUserTimeoutsToTerraform(struct?: DataIonoscloudMongoUserTimeoutsOutputReference | DataIonoscloudMongoUserTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudMongoUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudMongoUserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudMongoUserTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user ionoscloud_mongo_user}
*/
export declare class DataIonoscloudMongoUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_mongo_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_user ionoscloud_mongo_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudMongoUserConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudMongoUserConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _roles;
    get roles(): DataIonoscloudMongoUserRolesList;
    putRoles(value: DataIonoscloudMongoUserRoles[] | cdktf.IResolvable): void;
    resetRoles(): void;
    get rolesInput(): cdktf.IResolvable | DataIonoscloudMongoUserRoles[] | undefined;
    private _timeouts;
    get timeouts(): DataIonoscloudMongoUserTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudMongoUserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudMongoUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
