import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/volume#datacenter_id DataIonoscloudVolume#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/volume#id DataIonoscloudVolume#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/volume#name DataIonoscloudVolume#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/volume#timeouts DataIonoscloudVolume#timeouts}
    */
    readonly timeouts?: DataIonoscloudVolumeTimeouts;
}
export interface DataIonoscloudVolumeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/volume#create DataIonoscloudVolume#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/volume#default DataIonoscloudVolume#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/volume#delete DataIonoscloudVolume#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/volume#update DataIonoscloudVolume#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudVolumeTimeoutsToTerraform(struct?: DataIonoscloudVolumeTimeoutsOutputReference | DataIonoscloudVolumeTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudVolumeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudVolumeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudVolumeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/volume ionoscloud_volume}
*/
export declare class DataIonoscloudVolume extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_volume";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/volume ionoscloud_volume} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudVolumeConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudVolumeConfig);
    get availabilityZone(): string;
    get backupUnitId(): string;
    get bootServer(): string;
    get bus(): string;
    get cpuHotPlug(): cdktf.IResolvable;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    get deviceNumber(): number;
    get discVirtioHotPlug(): cdktf.IResolvable;
    get discVirtioHotUnplug(): cdktf.IResolvable;
    get diskType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get image(): string;
    get imageAlias(): string;
    get imagePassword(): string;
    get licenceType(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get nicHotPlug(): cdktf.IResolvable;
    get nicHotUnplug(): cdktf.IResolvable;
    get ramHotPlug(): cdktf.IResolvable;
    get size(): number;
    get sshkey(): string;
    get userData(): string;
    private _timeouts;
    get timeouts(): DataIonoscloudVolumeTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudVolumeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudVolumeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
