# This file was auto-generated by Fern from our API Definition.

import typing

from backports.cached_property import cached_property

from ..environment import MercoaEnvironment
from .resources.bank_lookup.client import AsyncBankLookupClient, BankLookupClient
from .resources.counterparty.client import AsyncCounterpartyClient, CounterpartyClient
from .resources.entity.client import AsyncEntityClient, EntityClient
from .resources.invoice.client import AsyncInvoiceClient, InvoiceClient
from .resources.ocr.client import AsyncOcrClient, OcrClient
from .resources.organization.client import AsyncOrganizationClient, OrganizationClient
from .resources.payment_method.client import AsyncPaymentMethodClient, PaymentMethodClient
from .resources.payment_method_schema.client import AsyncPaymentMethodSchemaClient, PaymentMethodSchemaClient
from .resources.representative.client import AsyncRepresentativeClient, RepresentativeClient


class Mercoa:
    def __init__(
        self, *, environment: MercoaEnvironment = MercoaEnvironment.PRODUCTION, token: typing.Optional[str] = None
    ):
        self._environment = environment
        self._token = token

    @cached_property
    def bank_lookup(self) -> BankLookupClient:
        return BankLookupClient(environment=self._environment, token=self._token)

    @cached_property
    def counterparty(self) -> CounterpartyClient:
        return CounterpartyClient(environment=self._environment, token=self._token)

    @cached_property
    def entity(self) -> EntityClient:
        return EntityClient(environment=self._environment, token=self._token)

    @cached_property
    def invoice(self) -> InvoiceClient:
        return InvoiceClient(environment=self._environment, token=self._token)

    @cached_property
    def ocr(self) -> OcrClient:
        return OcrClient(environment=self._environment, token=self._token)

    @cached_property
    def organization(self) -> OrganizationClient:
        return OrganizationClient(environment=self._environment, token=self._token)

    @cached_property
    def payment_method_schema(self) -> PaymentMethodSchemaClient:
        return PaymentMethodSchemaClient(environment=self._environment, token=self._token)

    @cached_property
    def payment_method(self) -> PaymentMethodClient:
        return PaymentMethodClient(environment=self._environment, token=self._token)

    @cached_property
    def representative(self) -> RepresentativeClient:
        return RepresentativeClient(environment=self._environment, token=self._token)


class AsyncMercoa:
    def __init__(
        self, *, environment: MercoaEnvironment = MercoaEnvironment.PRODUCTION, token: typing.Optional[str] = None
    ):
        self._environment = environment
        self._token = token

    @cached_property
    def bank_lookup(self) -> AsyncBankLookupClient:
        return AsyncBankLookupClient(environment=self._environment, token=self._token)

    @cached_property
    def counterparty(self) -> AsyncCounterpartyClient:
        return AsyncCounterpartyClient(environment=self._environment, token=self._token)

    @cached_property
    def entity(self) -> AsyncEntityClient:
        return AsyncEntityClient(environment=self._environment, token=self._token)

    @cached_property
    def invoice(self) -> AsyncInvoiceClient:
        return AsyncInvoiceClient(environment=self._environment, token=self._token)

    @cached_property
    def ocr(self) -> AsyncOcrClient:
        return AsyncOcrClient(environment=self._environment, token=self._token)

    @cached_property
    def organization(self) -> AsyncOrganizationClient:
        return AsyncOrganizationClient(environment=self._environment, token=self._token)

    @cached_property
    def payment_method_schema(self) -> AsyncPaymentMethodSchemaClient:
        return AsyncPaymentMethodSchemaClient(environment=self._environment, token=self._token)

    @cached_property
    def payment_method(self) -> AsyncPaymentMethodClient:
        return AsyncPaymentMethodClient(environment=self._environment, token=self._token)

    @cached_property
    def representative(self) -> AsyncRepresentativeClient:
        return AsyncRepresentativeClient(environment=self._environment, token=self._token)
