# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ....core.datetime_utils import serialize_datetime
from .attachments import Attachments
from .ocr_mailbox import OcrMailbox


class EmailOcrRequest(pydantic.BaseModel):
    uuid: typing.List[str] = pydantic.Field(alias="Uuid")
    message_id: str = pydantic.Field(alias="MessageId")
    in_reply_to: typing.Optional[str] = pydantic.Field(alias="InReplyTo")
    from_: OcrMailbox = pydantic.Field(alias="From")
    to: typing.List[OcrMailbox] = pydantic.Field(alias="To")
    cc: typing.List[OcrMailbox] = pydantic.Field(alias="Cc")
    reply_to: typing.Optional[OcrMailbox] = pydantic.Field(alias="ReplyTo")
    sent_at_date: str = pydantic.Field(alias="SentAtDate")
    subject: str = pydantic.Field(alias="Subject")
    attachments: typing.List[Attachments] = pydantic.Field(alias="Attachments")
    headers: typing.Any = pydantic.Field(alias="Headers")
    spam_score: float = pydantic.Field(alias="SpamScore")
    extracted_markdown_message: typing.Optional[str] = pydantic.Field(alias="ExtractedMarkdownMessage")
    extracted_markdown_signature: typing.Optional[str] = pydantic.Field(alias="ExtractedMarkdownSignature")
    raw_html_body: typing.Optional[str] = pydantic.Field(alias="RawHtmlBody")
    raw_text_body: typing.Optional[str] = pydantic.Field(alias="RawTextBody")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
