# Generated by Django 4.0 on 2022-02-28 14:33

import django.contrib.gis.db.models.fields
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import mptt.fields
from django.db import migrations, models

import unicef_locations.libs


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='GatewayType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=64, unique=True, verbose_name='Name')),
                ('admin_level', models.PositiveSmallIntegerField(null=True, unique=True, verbose_name='Admin Level')),
            ],
            options={
                'verbose_name': 'Location Type',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='CartoDBTable',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('domain', models.CharField(max_length=254, verbose_name='Domain')),
                ('api_key', models.CharField(max_length=254, verbose_name='API Key')),
                ('table_name', models.CharField(max_length=254, verbose_name='Table Name')),
                ('display_name', models.CharField(blank=True, default='', max_length=254, verbose_name='Display Name')),
                ('admin_level', models.SmallIntegerField(verbose_name='Admin Level')),
                ('admin_level_name', models.CharField(max_length=64, verbose_name='Admin Level Name')),
                ('name_col', models.CharField(default='name', max_length=254, verbose_name='Name Column')),
                ('pcode_col', models.CharField(default='pcode', max_length=254, verbose_name='Pcode Column')),
                ('remap_table_name', models.CharField(blank=True, max_length=254, null=True, verbose_name='Remap Table Name')),
                ('parent_code_col', models.CharField(blank=True, default='', max_length=254, verbose_name='Parent Code Column')),
                ('color', models.CharField(blank=True, default=unicef_locations.libs.get_random_color, max_length=7, verbose_name='Color')),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='unicef_locations.cartodbtable', verbose_name='Parent')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
