import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type logzio::awsSecurityHub::collector::MODULE
 *
 * @schema CfnCollectorModuleProps
 */
export interface CfnCollectorModuleProps {
    /**
     * @schema CfnCollectorModuleProps#Parameters
     */
    readonly parameters?: CfnCollectorModulePropsParameters;
    /**
     * @schema CfnCollectorModuleProps#Resources
     */
    readonly resources?: CfnCollectorModulePropsResources;
}
/**
 * Converts an object of type 'CfnCollectorModuleProps' to JSON representation.
 */
export declare function toJson_CfnCollectorModuleProps(obj: CfnCollectorModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCollectorModulePropsParameters
 */
export interface CfnCollectorModulePropsParameters {
    /**
     * Your Logz.io operations token
     *
     * @schema CfnCollectorModulePropsParameters#logzioOperationsToken
     */
    readonly logzioOperationsToken?: CfnCollectorModulePropsParametersLogzioOperationsToken;
    /**
     * Your Logz.io listener with port 8070/8071. For example https://listener.logz.io:8071
     *
     * @schema CfnCollectorModulePropsParameters#logzioListener
     */
    readonly logzioListener?: CfnCollectorModulePropsParametersLogzioListener;
    /**
     * Log level for the function
     *
     * @schema CfnCollectorModulePropsParameters#logzioLogLevel
     */
    readonly logzioLogLevel?: CfnCollectorModulePropsParametersLogzioLogLevel;
}
/**
 * Converts an object of type 'CfnCollectorModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnCollectorModulePropsParameters(obj: CfnCollectorModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCollectorModulePropsResources
 */
export interface CfnCollectorModulePropsResources {
    /**
     * @schema CfnCollectorModulePropsResources#logzioSecurityHubCollector
     */
    readonly logzioSecurityHubCollector?: CfnCollectorModulePropsResourcesLogzioSecurityHubCollector;
    /**
     * @schema CfnCollectorModulePropsResources#eventRule
     */
    readonly eventRule?: CfnCollectorModulePropsResourcesEventRule;
    /**
     * @schema CfnCollectorModulePropsResources#lambdaPermissions
     */
    readonly lambdaPermissions?: CfnCollectorModulePropsResourcesLambdaPermissions;
    /**
     * @schema CfnCollectorModulePropsResources#lambdaIamRole
     */
    readonly lambdaIamRole?: CfnCollectorModulePropsResourcesLambdaIamRole;
}
/**
 * Converts an object of type 'CfnCollectorModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnCollectorModulePropsResources(obj: CfnCollectorModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * Your Logz.io operations token
 *
 * @schema CfnCollectorModulePropsParametersLogzioOperationsToken
 */
export interface CfnCollectorModulePropsParametersLogzioOperationsToken {
    /**
     * @schema CfnCollectorModulePropsParametersLogzioOperationsToken#Type
     */
    readonly type: string;
    /**
     * @schema CfnCollectorModulePropsParametersLogzioOperationsToken#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCollectorModulePropsParametersLogzioOperationsToken' to JSON representation.
 */
export declare function toJson_CfnCollectorModulePropsParametersLogzioOperationsToken(obj: CfnCollectorModulePropsParametersLogzioOperationsToken | undefined): Record<string, any> | undefined;
/**
 * Your Logz.io listener with port 8070/8071. For example https://listener.logz.io:8071
 *
 * @schema CfnCollectorModulePropsParametersLogzioListener
 */
export interface CfnCollectorModulePropsParametersLogzioListener {
    /**
     * @schema CfnCollectorModulePropsParametersLogzioListener#Type
     */
    readonly type: string;
    /**
     * @schema CfnCollectorModulePropsParametersLogzioListener#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCollectorModulePropsParametersLogzioListener' to JSON representation.
 */
export declare function toJson_CfnCollectorModulePropsParametersLogzioListener(obj: CfnCollectorModulePropsParametersLogzioListener | undefined): Record<string, any> | undefined;
/**
 * Log level for the function
 *
 * @schema CfnCollectorModulePropsParametersLogzioLogLevel
 */
export interface CfnCollectorModulePropsParametersLogzioLogLevel {
    /**
     * @schema CfnCollectorModulePropsParametersLogzioLogLevel#Type
     */
    readonly type: string;
    /**
     * @schema CfnCollectorModulePropsParametersLogzioLogLevel#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCollectorModulePropsParametersLogzioLogLevel' to JSON representation.
 */
export declare function toJson_CfnCollectorModulePropsParametersLogzioLogLevel(obj: CfnCollectorModulePropsParametersLogzioLogLevel | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCollectorModulePropsResourcesLogzioSecurityHubCollector
 */
export interface CfnCollectorModulePropsResourcesLogzioSecurityHubCollector {
    /**
     * @schema CfnCollectorModulePropsResourcesLogzioSecurityHubCollector#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCollectorModulePropsResourcesLogzioSecurityHubCollector#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCollectorModulePropsResourcesLogzioSecurityHubCollector' to JSON representation.
 */
export declare function toJson_CfnCollectorModulePropsResourcesLogzioSecurityHubCollector(obj: CfnCollectorModulePropsResourcesLogzioSecurityHubCollector | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCollectorModulePropsResourcesEventRule
 */
export interface CfnCollectorModulePropsResourcesEventRule {
    /**
     * @schema CfnCollectorModulePropsResourcesEventRule#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCollectorModulePropsResourcesEventRule#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCollectorModulePropsResourcesEventRule' to JSON representation.
 */
export declare function toJson_CfnCollectorModulePropsResourcesEventRule(obj: CfnCollectorModulePropsResourcesEventRule | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCollectorModulePropsResourcesLambdaPermissions
 */
export interface CfnCollectorModulePropsResourcesLambdaPermissions {
    /**
     * @schema CfnCollectorModulePropsResourcesLambdaPermissions#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCollectorModulePropsResourcesLambdaPermissions#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCollectorModulePropsResourcesLambdaPermissions' to JSON representation.
 */
export declare function toJson_CfnCollectorModulePropsResourcesLambdaPermissions(obj: CfnCollectorModulePropsResourcesLambdaPermissions | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCollectorModulePropsResourcesLambdaIamRole
 */
export interface CfnCollectorModulePropsResourcesLambdaIamRole {
    /**
     * @schema CfnCollectorModulePropsResourcesLambdaIamRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCollectorModulePropsResourcesLambdaIamRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCollectorModulePropsResourcesLambdaIamRole' to JSON representation.
 */
export declare function toJson_CfnCollectorModulePropsResourcesLambdaIamRole(obj: CfnCollectorModulePropsResourcesLambdaIamRole | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `logzio::awsSecurityHub::collector::MODULE`
 *
 * @cloudformationResource logzio::awsSecurityHub::collector::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnCollectorModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "logzio::awsSecurityHub::collector::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnCollectorModuleProps;
    /**
     * Create a new `logzio::awsSecurityHub::collector::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnCollectorModuleProps);
}
