import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
     * How often (in seconds) to send a health check. The default value is 5 seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#check_interval_sec ComputeHealthCheck#check_interval_sec}
     *
     * @stability stable
     */
    readonly checkIntervalSec?: number;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#description ComputeHealthCheck#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#healthy_threshold ComputeHealthCheck#healthy_threshold}
     *
     * @stability stable
     */
    readonly healthyThreshold?: number;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#name ComputeHealthCheck#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#project ComputeHealthCheck#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * How long (in seconds) to wait before claiming failure.
     *
     * The default value is 5 seconds.  It is invalid for timeoutSec to have
     * greater value than checkIntervalSec.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#timeout_sec ComputeHealthCheck#timeout_sec}
     *
     * @stability stable
     */
    readonly timeoutSec?: number;
    /**
     * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#unhealthy_threshold ComputeHealthCheck#unhealthy_threshold}
     *
     * @stability stable
     */
    readonly unhealthyThreshold?: number;
    /**
     * grpc_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#grpc_health_check ComputeHealthCheck#grpc_health_check}
     *
     * @stability stable
     */
    readonly grpcHealthCheck?: ComputeHealthCheckGrpcHealthCheck;
    /**
     * http2_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#http2_health_check ComputeHealthCheck#http2_health_check}
     *
     * @stability stable
     */
    readonly http2HealthCheck?: ComputeHealthCheckHttp2HealthCheck;
    /**
     * http_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#http_health_check ComputeHealthCheck#http_health_check}
     *
     * @stability stable
     */
    readonly httpHealthCheck?: ComputeHealthCheckHttpHealthCheck;
    /**
     * https_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#https_health_check ComputeHealthCheck#https_health_check}
     *
     * @stability stable
     */
    readonly httpsHealthCheck?: ComputeHealthCheckHttpsHealthCheck;
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#log_config ComputeHealthCheck#log_config}
     *
     * @stability stable
     */
    readonly logConfig?: ComputeHealthCheckLogConfig;
    /**
     * ssl_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#ssl_health_check ComputeHealthCheck#ssl_health_check}
     *
     * @stability stable
     */
    readonly sslHealthCheck?: ComputeHealthCheckSslHealthCheck;
    /**
     * tcp_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#tcp_health_check ComputeHealthCheck#tcp_health_check}
     *
     * @stability stable
     */
    readonly tcpHealthCheck?: ComputeHealthCheckTcpHealthCheck;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#timeouts ComputeHealthCheck#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeHealthCheckTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeHealthCheckGrpcHealthCheck {
    /**
     * The gRPC service name for the health check.
     *
     * The value of grpcServiceName has the following meanings by convention:
     * - Empty serviceName means the overall status of all services at the backend.
     * - Non-empty serviceName means the health of that gRPC service, as defined by the owner of the service.
     * The grpcServiceName can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#grpc_service_name ComputeHealthCheck#grpc_service_name}
     *
     * @stability stable
     */
    readonly grpcServiceName?: string;
    /**
     * The port number for the health check request.
     *
     * Must be specified if portName and portSpecification are not set
     * or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port ComputeHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_name ComputeHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, gRPC health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_specification ComputeHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
}
/**
 * @stability stable
 */
export declare class ComputeHealthCheckGrpcHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _grpcServiceName?;
    /**
     * @stability stable
     */
    get grpcServiceName(): string | undefined;
    /**
     * @stability stable
     */
    set grpcServiceName(value: string | undefined);
    /**
     * @stability stable
     */
    resetGrpcServiceName(): void;
    /**
     * @stability stable
     */
    get grpcServiceNameInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string | undefined;
    /**
     * @stability stable
     */
    set portName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string | undefined;
    /**
     * @stability stable
     */
    set portSpecification(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeHealthCheckHttp2HealthCheck {
    /**
     * The value of the host header in the HTTP2 health check request.
     *
     * If left empty (default value), the public IP on behalf of which this health
     * check is performed will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#host ComputeHealthCheck#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The TCP port number for the HTTP2 health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port ComputeHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_name ComputeHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, HTTP2 health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_specification ComputeHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#proxy_header ComputeHealthCheck#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * The request path of the HTTP2 health check request. The default value is /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#request_path ComputeHealthCheck#request_path}
     *
     * @stability stable
     */
    readonly requestPath?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#response ComputeHealthCheck#response}
     *
     * @stability stable
     */
    readonly response?: string;
}
/**
 * @stability stable
 */
export declare class ComputeHealthCheckHttp2HealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _host?;
    /**
     * @stability stable
     */
    get host(): string | undefined;
    /**
     * @stability stable
     */
    set host(value: string | undefined);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string | undefined;
    /**
     * @stability stable
     */
    set portName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string | undefined;
    /**
     * @stability stable
     */
    set portSpecification(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string | undefined;
    /**
     * @stability stable
     */
    set proxyHeader(value: string | undefined);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    /**
     * @stability stable
     */
    get requestPath(): string | undefined;
    /**
     * @stability stable
     */
    set requestPath(value: string | undefined);
    /**
     * @stability stable
     */
    resetRequestPath(): void;
    /**
     * @stability stable
     */
    get requestPathInput(): string | undefined;
    private _response?;
    /**
     * @stability stable
     */
    get response(): string | undefined;
    /**
     * @stability stable
     */
    set response(value: string | undefined);
    /**
     * @stability stable
     */
    resetResponse(): void;
    /**
     * @stability stable
     */
    get responseInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeHealthCheckHttpHealthCheck {
    /**
     * The value of the host header in the HTTP health check request.
     *
     * If left empty (default value), the public IP on behalf of which this health
     * check is performed will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#host ComputeHealthCheck#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The TCP port number for the HTTP health check request. The default value is 80.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port ComputeHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_name ComputeHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, HTTP health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_specification ComputeHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#proxy_header ComputeHealthCheck#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * The request path of the HTTP health check request. The default value is /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#request_path ComputeHealthCheck#request_path}
     *
     * @stability stable
     */
    readonly requestPath?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#response ComputeHealthCheck#response}
     *
     * @stability stable
     */
    readonly response?: string;
}
/**
 * @stability stable
 */
export declare class ComputeHealthCheckHttpHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _host?;
    /**
     * @stability stable
     */
    get host(): string | undefined;
    /**
     * @stability stable
     */
    set host(value: string | undefined);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string | undefined;
    /**
     * @stability stable
     */
    set portName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string | undefined;
    /**
     * @stability stable
     */
    set portSpecification(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string | undefined;
    /**
     * @stability stable
     */
    set proxyHeader(value: string | undefined);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    /**
     * @stability stable
     */
    get requestPath(): string | undefined;
    /**
     * @stability stable
     */
    set requestPath(value: string | undefined);
    /**
     * @stability stable
     */
    resetRequestPath(): void;
    /**
     * @stability stable
     */
    get requestPathInput(): string | undefined;
    private _response?;
    /**
     * @stability stable
     */
    get response(): string | undefined;
    /**
     * @stability stable
     */
    set response(value: string | undefined);
    /**
     * @stability stable
     */
    resetResponse(): void;
    /**
     * @stability stable
     */
    get responseInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeHealthCheckHttpsHealthCheck {
    /**
     * The value of the host header in the HTTPS health check request.
     *
     * If left empty (default value), the public IP on behalf of which this health
     * check is performed will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#host ComputeHealthCheck#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The TCP port number for the HTTPS health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port ComputeHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_name ComputeHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, HTTPS health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_specification ComputeHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#proxy_header ComputeHealthCheck#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * The request path of the HTTPS health check request. The default value is /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#request_path ComputeHealthCheck#request_path}
     *
     * @stability stable
     */
    readonly requestPath?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#response ComputeHealthCheck#response}
     *
     * @stability stable
     */
    readonly response?: string;
}
/**
 * @stability stable
 */
export declare class ComputeHealthCheckHttpsHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _host?;
    /**
     * @stability stable
     */
    get host(): string | undefined;
    /**
     * @stability stable
     */
    set host(value: string | undefined);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string | undefined;
    /**
     * @stability stable
     */
    set portName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string | undefined;
    /**
     * @stability stable
     */
    set portSpecification(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string | undefined;
    /**
     * @stability stable
     */
    set proxyHeader(value: string | undefined);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    /**
     * @stability stable
     */
    get requestPath(): string | undefined;
    /**
     * @stability stable
     */
    set requestPath(value: string | undefined);
    /**
     * @stability stable
     */
    resetRequestPath(): void;
    /**
     * @stability stable
     */
    get requestPathInput(): string | undefined;
    private _response?;
    /**
     * @stability stable
     */
    get response(): string | undefined;
    /**
     * @stability stable
     */
    set response(value: string | undefined);
    /**
     * @stability stable
     */
    resetResponse(): void;
    /**
     * @stability stable
     */
    get responseInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeHealthCheckLogConfig {
    /**
     * Indicates whether or not to export logs.
     *
     * This is false by default,
     * which means no health check logging will be done.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#enable ComputeHealthCheck#enable}
     *
     * @stability stable
     */
    readonly enable?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class ComputeHealthCheckLogConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enable?;
    /**
     * @stability stable
     */
    get enable(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enable(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnable(): void;
    /**
     * @stability stable
     */
    get enableInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ComputeHealthCheckSslHealthCheck {
    /**
     * The TCP port number for the SSL health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port ComputeHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_name ComputeHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, SSL health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_specification ComputeHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#proxy_header ComputeHealthCheck#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * The application data to send once the SSL connection has been established (default value is empty).
     *
     * If both request and response are
     * empty, the connection establishment alone will indicate health. The request
     * data can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#request ComputeHealthCheck#request}
     *
     * @stability stable
     */
    readonly request?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#response ComputeHealthCheck#response}
     *
     * @stability stable
     */
    readonly response?: string;
}
/**
 * @stability stable
 */
export declare class ComputeHealthCheckSslHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string | undefined;
    /**
     * @stability stable
     */
    set portName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string | undefined;
    /**
     * @stability stable
     */
    set portSpecification(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string | undefined;
    /**
     * @stability stable
     */
    set proxyHeader(value: string | undefined);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): string | undefined;
    /**
     * @stability stable
     */
    set request(value: string | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): string | undefined;
    private _response?;
    /**
     * @stability stable
     */
    get response(): string | undefined;
    /**
     * @stability stable
     */
    set response(value: string | undefined);
    /**
     * @stability stable
     */
    resetResponse(): void;
    /**
     * @stability stable
     */
    get responseInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeHealthCheckTcpHealthCheck {
    /**
     * The TCP port number for the TCP health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port ComputeHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_name ComputeHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, TCP health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#port_specification ComputeHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#proxy_header ComputeHealthCheck#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * The application data to send once the TCP connection has been established (default value is empty).
     *
     * If both request and response are
     * empty, the connection establishment alone will indicate health. The request
     * data can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#request ComputeHealthCheck#request}
     *
     * @stability stable
     */
    readonly request?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#response ComputeHealthCheck#response}
     *
     * @stability stable
     */
    readonly response?: string;
}
/**
 * @stability stable
 */
export declare class ComputeHealthCheckTcpHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string | undefined;
    /**
     * @stability stable
     */
    set portName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string | undefined;
    /**
     * @stability stable
     */
    set portSpecification(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string | undefined;
    /**
     * @stability stable
     */
    set proxyHeader(value: string | undefined);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): string | undefined;
    /**
     * @stability stable
     */
    set request(value: string | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): string | undefined;
    private _response?;
    /**
     * @stability stable
     */
    get response(): string | undefined;
    /**
     * @stability stable
     */
    set response(value: string | undefined);
    /**
     * @stability stable
     */
    resetResponse(): void;
    /**
     * @stability stable
     */
    get responseInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeHealthCheckTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#create ComputeHealthCheck#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#delete ComputeHealthCheck#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html#update ComputeHealthCheck#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ComputeHealthCheckTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html google_compute_health_check}.
 *
 * @stability stable
 */
export declare class ComputeHealthCheck extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_health_check.html google_compute_health_check} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeHealthCheckConfig);
    private _checkIntervalSec?;
    /**
     * @stability stable
     */
    get checkIntervalSec(): number | undefined;
    /**
     * @stability stable
     */
    set checkIntervalSec(value: number | undefined);
    /**
     * @stability stable
     */
    resetCheckIntervalSec(): void;
    /**
     * @stability stable
     */
    get checkIntervalSecInput(): number | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _healthyThreshold?;
    /**
     * @stability stable
     */
    get healthyThreshold(): number | undefined;
    /**
     * @stability stable
     */
    set healthyThreshold(value: number | undefined);
    /**
     * @stability stable
     */
    resetHealthyThreshold(): void;
    /**
     * @stability stable
     */
    get healthyThresholdInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeoutSec?;
    /**
     * @stability stable
     */
    get timeoutSec(): number | undefined;
    /**
     * @stability stable
     */
    set timeoutSec(value: number | undefined);
    /**
     * @stability stable
     */
    resetTimeoutSec(): void;
    /**
     * @stability stable
     */
    get timeoutSecInput(): number | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _unhealthyThreshold?;
    /**
     * @stability stable
     */
    get unhealthyThreshold(): number | undefined;
    /**
     * @stability stable
     */
    set unhealthyThreshold(value: number | undefined);
    /**
     * @stability stable
     */
    resetUnhealthyThreshold(): void;
    /**
     * @stability stable
     */
    get unhealthyThresholdInput(): number | undefined;
    private _grpcHealthCheck?;
    private __grpcHealthCheckOutput;
    /**
     * @stability stable
     */
    get grpcHealthCheck(): ComputeHealthCheckGrpcHealthCheckOutputReference;
    /**
     * @stability stable
     */
    putGrpcHealthCheck(value: ComputeHealthCheckGrpcHealthCheck | undefined): void;
    /**
     * @stability stable
     */
    resetGrpcHealthCheck(): void;
    /**
     * @stability stable
     */
    get grpcHealthCheckInput(): ComputeHealthCheckGrpcHealthCheck | undefined;
    private _http2HealthCheck?;
    private __http2HealthCheckOutput;
    /**
     * @stability stable
     */
    get http2HealthCheck(): ComputeHealthCheckHttp2HealthCheckOutputReference;
    /**
     * @stability stable
     */
    putHttp2HealthCheck(value: ComputeHealthCheckHttp2HealthCheck | undefined): void;
    /**
     * @stability stable
     */
    resetHttp2HealthCheck(): void;
    /**
     * @stability stable
     */
    get http2HealthCheckInput(): ComputeHealthCheckHttp2HealthCheck | undefined;
    private _httpHealthCheck?;
    private __httpHealthCheckOutput;
    /**
     * @stability stable
     */
    get httpHealthCheck(): ComputeHealthCheckHttpHealthCheckOutputReference;
    /**
     * @stability stable
     */
    putHttpHealthCheck(value: ComputeHealthCheckHttpHealthCheck | undefined): void;
    /**
     * @stability stable
     */
    resetHttpHealthCheck(): void;
    /**
     * @stability stable
     */
    get httpHealthCheckInput(): ComputeHealthCheckHttpHealthCheck | undefined;
    private _httpsHealthCheck?;
    private __httpsHealthCheckOutput;
    /**
     * @stability stable
     */
    get httpsHealthCheck(): ComputeHealthCheckHttpsHealthCheckOutputReference;
    /**
     * @stability stable
     */
    putHttpsHealthCheck(value: ComputeHealthCheckHttpsHealthCheck | undefined): void;
    /**
     * @stability stable
     */
    resetHttpsHealthCheck(): void;
    /**
     * @stability stable
     */
    get httpsHealthCheckInput(): ComputeHealthCheckHttpsHealthCheck | undefined;
    private _logConfig?;
    private __logConfigOutput;
    /**
     * @stability stable
     */
    get logConfig(): ComputeHealthCheckLogConfigOutputReference;
    /**
     * @stability stable
     */
    putLogConfig(value: ComputeHealthCheckLogConfig | undefined): void;
    /**
     * @stability stable
     */
    resetLogConfig(): void;
    /**
     * @stability stable
     */
    get logConfigInput(): ComputeHealthCheckLogConfig | undefined;
    private _sslHealthCheck?;
    private __sslHealthCheckOutput;
    /**
     * @stability stable
     */
    get sslHealthCheck(): ComputeHealthCheckSslHealthCheckOutputReference;
    /**
     * @stability stable
     */
    putSslHealthCheck(value: ComputeHealthCheckSslHealthCheck | undefined): void;
    /**
     * @stability stable
     */
    resetSslHealthCheck(): void;
    /**
     * @stability stable
     */
    get sslHealthCheckInput(): ComputeHealthCheckSslHealthCheck | undefined;
    private _tcpHealthCheck?;
    private __tcpHealthCheckOutput;
    /**
     * @stability stable
     */
    get tcpHealthCheck(): ComputeHealthCheckTcpHealthCheckOutputReference;
    /**
     * @stability stable
     */
    putTcpHealthCheck(value: ComputeHealthCheckTcpHealthCheck | undefined): void;
    /**
     * @stability stable
     */
    resetTcpHealthCheck(): void;
    /**
     * @stability stable
     */
    get tcpHealthCheckInput(): ComputeHealthCheckTcpHealthCheck | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeHealthCheckTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeHealthCheckTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeHealthCheckTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
