import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_vpn_gateway.html#name DataGoogleComputeVpnGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_vpn_gateway.html#project DataGoogleComputeVpnGateway#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_vpn_gateway.html#region DataGoogleComputeVpnGateway#region}.
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_vpn_gateway.html google_compute_vpn_gateway}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeVpnGateway extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_vpn_gateway.html google_compute_vpn_gateway} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeVpnGatewayConfig);
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get network(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
