import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleMonitoringMeshIstioServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifier for the mesh in which this Istio service is defined.
     *
     * Corresponds to the meshUid metric label in Istio metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service.html#mesh_uid DataGoogleMonitoringMeshIstioService#mesh_uid}
     *
     * @stability stable
     */
    readonly meshUid: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service.html#project DataGoogleMonitoringMeshIstioService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The name of the Istio service underlying this service.
     *
     * Corresponds to the destination_service_name metric label in Istio metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service.html#service_name DataGoogleMonitoringMeshIstioService#service_name}
     *
     * @stability stable
     */
    readonly serviceName: string;
    /**
     * The namespace of the Istio service underlying this service.
     *
     * Corresponds to the destination_service_namespace metric label in Istio metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service.html#service_namespace DataGoogleMonitoringMeshIstioService#service_namespace}
     *
     * @stability stable
     */
    readonly serviceNamespace: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleMonitoringMeshIstioServiceTelemetry extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get resourceName(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service.html google_monitoring_mesh_istio_service}.
 *
 * @stability stable
 */
export declare class DataGoogleMonitoringMeshIstioService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service.html google_monitoring_mesh_istio_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleMonitoringMeshIstioServiceConfig);
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _meshUid?;
    /**
     * @stability stable
     */
    get meshUid(): string;
    /**
     * @stability stable
     */
    set meshUid(value: string);
    /**
     * @stability stable
     */
    get meshUidInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceId(): string;
    private _serviceName?;
    /**
     * @stability stable
     */
    get serviceName(): string;
    /**
     * @stability stable
     */
    set serviceName(value: string);
    /**
     * @stability stable
     */
    get serviceNameInput(): string | undefined;
    private _serviceNamespace?;
    /**
     * @stability stable
     */
    get serviceNamespace(): string;
    /**
     * @stability stable
     */
    set serviceNamespace(value: string);
    /**
     * @stability stable
     */
    get serviceNamespaceInput(): string | undefined;
    /**
     * @stability stable
     */
    telemetry(index: string): DataGoogleMonitoringMeshIstioServiceTelemetry;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
