import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GkeHubMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
     * Labels to apply to this membership.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#labels GkeHubMembership#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The client-provided identifier of the membership.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#membership_id GkeHubMembership#membership_id}
     *
     * @stability stable
     */
    readonly membershipId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#project GkeHubMembership#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * authority block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#authority GkeHubMembership#authority}
     *
     * @stability stable
     */
    readonly authority?: GkeHubMembershipAuthority;
    /**
     * endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#endpoint GkeHubMembership#endpoint}
     *
     * @stability stable
     */
    readonly endpoint?: GkeHubMembershipEndpoint;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#timeouts GkeHubMembership#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: GkeHubMembershipTimeouts;
}
/**
 * @stability stable
 */
export interface GkeHubMembershipAuthority {
    /**
     * A JSON Web Token (JWT) issuer URI.
     *
     * 'issuer' must start with 'https://' and // be a valid
     * with length <2000 characters. For example: 'https://container.googleapis.com/v1/projects/my-project/locations/us-west1/clusters/my-cluster' (must be 'locations' rather than 'zones'). If the cluster is provisioned with Terraform, this is '"https://container.googleapis.com/v1/${google_container_cluster.my-cluster.id}"'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#issuer GkeHubMembership#issuer}
     *
     * @stability stable
     */
    readonly issuer: string;
}
/**
 * @stability stable
 */
export declare class GkeHubMembershipAuthorityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _issuer?;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    set issuer(value: string);
    /**
     * @stability stable
     */
    get issuerInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface GkeHubMembershipEndpointGkeCluster {
    /**
     * Self-link of the GCP resource for the GKE cluster.
     *
     * For example: '//container.googleapis.com/projects/my-project/zones/us-west1-a/clusters/my-cluster'.
     * It can be at the most 1000 characters in length. If the cluster is provisioned with Terraform,
     * this can be '"//container.googleapis.com/${google_container_cluster.my-cluster.id}"' or
     * 'google_container_cluster.my-cluster.id'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#resource_link GkeHubMembership#resource_link}
     *
     * @stability stable
     */
    readonly resourceLink: string;
}
/**
 * @stability stable
 */
export declare class GkeHubMembershipEndpointGkeClusterOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resourceLink?;
    /**
     * @stability stable
     */
    get resourceLink(): string;
    /**
     * @stability stable
     */
    set resourceLink(value: string);
    /**
     * @stability stable
     */
    get resourceLinkInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface GkeHubMembershipEndpoint {
    /**
     * gke_cluster block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#gke_cluster GkeHubMembership#gke_cluster}
     *
     * @stability stable
     */
    readonly gkeCluster?: GkeHubMembershipEndpointGkeCluster;
}
/**
 * @stability stable
 */
export declare class GkeHubMembershipEndpointOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _gkeCluster?;
    private __gkeClusterOutput;
    /**
     * @stability stable
     */
    get gkeCluster(): GkeHubMembershipEndpointGkeClusterOutputReference;
    /**
     * @stability stable
     */
    putGkeCluster(value: GkeHubMembershipEndpointGkeCluster | undefined): void;
    /**
     * @stability stable
     */
    resetGkeCluster(): void;
    /**
     * @stability stable
     */
    get gkeClusterInput(): GkeHubMembershipEndpointGkeCluster | undefined;
}
/**
 * @stability stable
 */
export interface GkeHubMembershipTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#create GkeHubMembership#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#delete GkeHubMembership#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#update GkeHubMembership#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class GkeHubMembershipTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html google_gke_hub_membership}.
 *
 * @stability stable
 */
export declare class GkeHubMembership extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html google_gke_hub_membership} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GkeHubMembershipConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _membershipId?;
    /**
     * @stability stable
     */
    get membershipId(): string;
    /**
     * @stability stable
     */
    set membershipId(value: string);
    /**
     * @stability stable
     */
    get membershipIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _authority?;
    private __authorityOutput;
    /**
     * @stability stable
     */
    get authority(): GkeHubMembershipAuthorityOutputReference;
    /**
     * @stability stable
     */
    putAuthority(value: GkeHubMembershipAuthority | undefined): void;
    /**
     * @stability stable
     */
    resetAuthority(): void;
    /**
     * @stability stable
     */
    get authorityInput(): GkeHubMembershipAuthority | undefined;
    private _endpoint?;
    private __endpointOutput;
    /**
     * @stability stable
     */
    get endpoint(): GkeHubMembershipEndpointOutputReference;
    /**
     * @stability stable
     */
    putEndpoint(value: GkeHubMembershipEndpoint | undefined): void;
    /**
     * @stability stable
     */
    resetEndpoint(): void;
    /**
     * @stability stable
     */
    get endpointInput(): GkeHubMembershipEndpoint | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): GkeHubMembershipTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: GkeHubMembershipTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): GkeHubMembershipTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
