# lusid-drive-sdk
FINBOURNE Technology

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.254
- Package version: 0.1.254
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.finbourne.com](https://www.finbourne.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import lusid_drive 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lusid_drive
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import lusid_drive
from lusid_drive.rest import ApiException
from pprint import pprint

configuration = lusid_drive.Configuration()
# Configure OAuth2 access token for authorization: oauth2
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# Defining host is optional and default to https://fbn-ci.lusid.com/drive
configuration.host = "https://fbn-ci.lusid.com/drive"
# Create an instance of the API class
api_instance = lusid_drive.ApplicationMetadataApi(lusid_drive.ApiClient(configuration))

try:
    # [EARLY ACCESS] Get resources available for access control
    api_response = api_instance.list_access_controlled_resources()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ApplicationMetadataApi->list_access_controlled_resources: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://fbn-ci.lusid.com/drive*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationMetadataApi* | [**list_access_controlled_resources**](docs/ApplicationMetadataApi.md#list_access_controlled_resources) | **GET** /api/metadata/access/resources | [EARLY ACCESS] Get resources available for access control
*FilesApi* | [**create_file**](docs/FilesApi.md#create_file) | **POST** /api/files | [BETA] Uploads a file to Lusid Drive. If using an SDK, consider using the UploadAsStreamAsync function for larger files instead.
*FilesApi* | [**delete_file**](docs/FilesApi.md#delete_file) | **DELETE** /api/files/{id} | [BETA] Deletes a file from Drive.
*FilesApi* | [**download_file**](docs/FilesApi.md#download_file) | **GET** /api/files/{id}/contents | [BETA] Download the file from Drive.
*FilesApi* | [**get_file**](docs/FilesApi.md#get_file) | **GET** /api/files/{id} | [BETA] Get a file stored in Drive.
*FilesApi* | [**update_file_contents**](docs/FilesApi.md#update_file_contents) | **PUT** /api/files/{id}/contents | [BETA] Updates contents of a file in Drive.
*FilesApi* | [**update_file_metadata**](docs/FilesApi.md#update_file_metadata) | **PUT** /api/files/{id} | [BETA] Updates metadata for a file in Drive.
*FoldersApi* | [**create_folder**](docs/FoldersApi.md#create_folder) | **POST** /api/folders | [BETA] Create a new folder in LUSID Drive
*FoldersApi* | [**delete_folder**](docs/FoldersApi.md#delete_folder) | **DELETE** /api/folders/{id} | [BETA] Delete a specified folder and all subfolders
*FoldersApi* | [**get_folder**](docs/FoldersApi.md#get_folder) | **GET** /api/folders/{id} | [BETA] Get metadata of folder
*FoldersApi* | [**get_folder_contents**](docs/FoldersApi.md#get_folder_contents) | **GET** /api/folders/{id}/contents | [BETA] List contents of a folder
*FoldersApi* | [**get_root_folder**](docs/FoldersApi.md#get_root_folder) | **GET** /api/folders | [BETA] List contents of root folder
*FoldersApi* | [**move_folder**](docs/FoldersApi.md#move_folder) | **POST** /api/folders/{id} | [BETA] Move files to specified folder
*FoldersApi* | [**update_folder**](docs/FoldersApi.md#update_folder) | **PUT** /api/folders/{id} | [BETA] Update an existing folder&#39;s name, path
*SearchApi* | [**search**](docs/SearchApi.md#search) | **POST** /api/search | [BETA] Search for a file or folder with a given name and path


## Documentation For Models

 - [AccessControlledAction](docs/AccessControlledAction.md)
 - [AccessControlledResource](docs/AccessControlledResource.md)
 - [ActionId](docs/ActionId.md)
 - [CreateFolder](docs/CreateFolder.md)
 - [IdSelectorDefinition](docs/IdSelectorDefinition.md)
 - [IdentifierPartSchema](docs/IdentifierPartSchema.md)
 - [Link](docs/Link.md)
 - [LusidProblemDetails](docs/LusidProblemDetails.md)
 - [LusidValidationProblemDetails](docs/LusidValidationProblemDetails.md)
 - [PagedResourceListOfStorageObject](docs/PagedResourceListOfStorageObject.md)
 - [ResourceListOfAccessControlledResource](docs/ResourceListOfAccessControlledResource.md)
 - [SearchBody](docs/SearchBody.md)
 - [StorageObject](docs/StorageObject.md)
 - [UpdateFile](docs/UpdateFile.md)
 - [UpdateFolder](docs/UpdateFolder.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://lusid.okta.com/oauth2/default/v1/authorize
- **Scopes**: N/A


## Author

info@finbourne.com


