import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig } from '@aws-cdk/aws-apigatewayv2-alpha';
import * as elbv2 from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { HttpPrivateIntegrationOptions } from './base-types';
import { HttpPrivateIntegration } from './private/integration';
/**
 * Properties to initialize `HttpNlbIntegration`.
 */
export interface HttpNlbIntegrationProps extends HttpPrivateIntegrationOptions {
}
/**
 * The Network Load Balancer integration resource for HTTP API
 */
export declare class HttpNlbIntegration extends HttpPrivateIntegration {
    private readonly listener;
    private readonly props;
    /**
     * @param id id of the underlying integration construct
     * @param listener the ELB network listener
     * @param props properties to configure the integration
     */
    constructor(id: string, listener: elbv2.INetworkListener, props?: HttpNlbIntegrationProps);
    bind(options: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
