# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['coveo_stew', 'coveo_stew.ci', 'coveo_stew.metadata']

package_data = \
{'': ['*'], 'coveo_stew': ['package_resources/*']}

install_requires = \
['black==20.8b1',
 'click',
 'coveo-functools>=1.0.0,<2.0.0',
 'coveo-itertools>=1.0.0,<2.0.0',
 'coveo-styles>=1.0.0,<2.0.0',
 'coveo-systools>=1.0.0,<2.0.0',
 'junit-xml',
 'mypy',
 'poetry>=1.1.4,<2.0.0',
 'toml',
 'typing_extensions']

entry_points = \
{'console_scripts': ['pyproject = coveo_stew.commands:stew',
                     'stew = coveo_stew.commands:stew']}

setup_kwargs = {
    'name': 'coveo-stew',
    'version': '1.2.2',
    'description': 'Opinionated python packaging and development utilities',
    'long_description': '# coveo-stew\n\nExtra magic for poetry-backed projects with CI and batch operations in mind.\n\n\n## Use cases\n\n- You don\'t want to spend time writing the setup/test/report/publish/tag CI workflow\n- You want to work with multiple python projects in a single repository\n- You need a way to download locked dependencies and install them offline later\n\n\n# Features\n\n## poetry on steroids / offline distribution\n- Orchestrates several isolated poetry projects in one repo\n- Supports unpublished, local-only libraries and projects\n- Generates offline installation package from lock files\n\n## developer tools\n- Batch support for common operations, such as poetry lock and poetry install\n- Specialized development environment support (called pydev)\n\n## ci tools\n- Builtin, config-free pytest and mypy checks\n- Able to resolve some checks automatically (e.g.: lock file is outdated? call poetry lock!)\n- JUnit report generation\n- Github action\n\n\n# Installation\n\nIt is recommended to install using [pipx](https://github.com/pipxproject/pipx) in order to isolate this into a nice little space:\n\n```\npip3 install pipx --user\npipx install coveo-stew\n```\n\nIf you don\'t use pipx, make sure to isolate the installation into a virtual environment, otherwise it may interfere with an existing poetry installation.\n\n\n# Commands\n\n## General command usage\n\nUnless a project name is specified, most commands will operate on all projects in a git repository based on the current working folder:\n\n- `stew <command>`\n    - Perform a command on all projects\n- `stew <command> --help`\n    - Obtain help about a particular command\n- `stew <command> <project-name>`\n    - Perform the command on all projects with `<project-name>` in their name (partial match)\n- `stew <command> <project-name> --exact-match`\n    - Disable partial project name matching\n\nThe main commands are summarized below.\n\n\n## `stew ci`\n\nOrchestrates the CI process over one or multiple projects. \n\nErrors will show in the console and in junit xml reports generated inside the `.ci` folder.\n\nConfiguration is done through each `pyproject.toml` file; default values are shown:\n\n```\n[tool.stew.ci]\nmypy = true\npoetry-check = true\ncheck-outdated = true\npytest = false\noffline-build = false\n```\n\n### runner options\n\nThe value type of these items is designed to be extensible.\n\n#### pytest options\n\n```\n[tool.stew.ci]\n\n# configure the markers to test\npytest = { marker-expression = \'not docker_tests\' }\n\n# disable the doctests\npytest = { doctest-modules = False }\n```\n\n#### mypy options\n\n```\n[tool.stew.ci]\n\n# disable stew\'s strict mypy config (i.e.: let mypy find its config)\nmypy = { set-config = False } \n\n# use a specific config (path relative to `pyproject.toml`\'s folder)\nmypy = { set-config = "mypy.ini" }\n```\n\n\n## `stew build`\n\nStore the project and its **locked dependencies** to disk. \n\nOptimally used to create truly repeatable builds and workflows (e.g.: docker images, terraform, S3, puppet...)\n\nThe folder can later be installed offline with `pip install --no-index --find-links <folder> <project-name>`\n\n**Make sure your target `<folder>` is clean**: Keep in mind that `pip` will still use the `pyproject.toml` constraints when installing, not `poetry.lock`. \nThe system works when the locked version is the only thing that `pip` can find in the `<folder>`.\n\n\n### `stew fix-outdated`\n\nChecks for out-of-date files and automatically updates them.\n\nSummary of actions:\n- `poetry lock` if `pyproject.toml` changed but not the `poetry.lock`\n- `stew pull-dev-requirements` if a pydev project\'s dev-requirements are out of sync\n\n\n### `stew bump`\n\nCalls `poetry lock` on all projects.\n\n\n# How to depend on a local library\n\nWe leverage poetry\'s `path` constraint in a very specific way:\n\n```\n[tool.poetry.dependencies]\nmy-package = { version = "^2.4" }\n\n[tool.poetry.dev-dependencies]\nmy-package = { path = "../my-package/" }\n```\n\nEssentially, the behavior we\'re looking for:\n\n- Through `pip install`, it will obtain the latest `^2.4` from `pypi.org`\n- Through `poetry install`, which is only meant for development, the source is fetched from the disk\n\n\n# pydev (development environment)\n\nProjects marked as pydev behave as "one ring to rule them all"; its pyproject.toml file links most/all the \npython projects in a repository for developer convenience, so that one can work in any of the projects of the \nrepository without having to configure multiple environments in the IDE). \n\n\n## How to enable pydev\n\nThis functionality is enabled by adding the following to your `pyproject.toml`:\n\n```\n[tool.stew]\npydev = true\n```\n\nThe marker above comes with a few behavior differences in the way it interacts with stew and poetry:\n\n- it cannot be packaged, published or even pip-installed\n- `stew ci` will skip it\n- the `tool.poetry.dev-dependencies` section is reserved, can be generated and updated through stew\'s `pull-dev-requirements` and `fix-outdated` commands\n\nAs such, the pydev functionality is only suitable to enable seamless development between python projects in the repository.\n\n## How to use pydev\n\n1. Call `poetry install` from the root of the repository\n1. Obtain the location of the virtual environment (i.e.: `poetry env list --full-path`)\n1. Configure your IDE to use the python interpreter from that location\n\nIf your IDE is python-smart, it should be able to pick up all imports automatically, regardless of your PYTHONPATH or your working directory.\nSince the local source is linked to, any change to the source code will be reflected on the next run.\n\n\n# FAQ\n\n## constraints vs locks - where do they apply?\n\nWhen you call `poetry install`, you end up installing packages based on the `poetry.lock` file.\nThe resulting packages will always be the same, no matter what.\nThis is the dev scenario.\n\nWhen you call `pip install`, you are installing packages based on the constraints placed in a `pyproject.toml` or a `setup.py` file.\nUnless the constraints are hard pinned versions, the resulting packages are not guaranteed and will depend on the point in time when the installation is performed, among other factors.\nThis is the shared library scenario.\n\nWhen you use poetry, you cover the two scenarios above.\n\nThe third scenario is the private business use case: you want to freeze your dependencies in time so that everything from the developer to the CI servers to the production system is identical.\nEssentially, you want `poetry install` without the dev requirements.\n\nThis functionality is provided out of the box by `stew build`, which creates a pip-installable package from the lock file that you can then stash in a private storage of your choice or pass around your deployments.\n\n\n## How to provision a production system\n\n### Preparing the virtual environment\n\nYou can keep `poetry` and `stew` off your production environment by creating a frozen archive of your application or library from your CI servers (docker used as example):\n\n- Use the `stew build` tool which:\n    - performs a `poetry build` on your project\n    - calls `pip download` based on the content of the lock file\n    - Moves the artifacts to the `.wheels` folder of your repo (can be configured with `--target`)\n- Recommended: Use the `--python` switch when calling `stew build` to specify which python executable to use! Make sure to use a python interpreter that matches the os/arch/bits of the system you want to provision\n- Include the `.wheels` folder into your Docker build context\n- In your Dockerfile:\n    - ADD the `.wheels` folder\n    - Manage the `pip` version! Either update it to latest, or pin it to something.\n    - Prepare a python environment\n        - Use `python -m venv <location>` to create a virtual environment natively.\n        - Note the executable location... typically (`location/bin/python` or `location/Scripts/python.exe`)\n    - Install your application into the python environment you just created:\n        - Use `<venv-python-exec> -m pip install <your-package> --no-index --find-links <wheels-folder-location>`\n    - You may delete the `.wheels` folder if you want. Consider keeping a copy of the lock file within the docker image, for reference\n    \n\n### Using the environment\n\nUsing the correct interpreter is all you need to do. There is no activation script or environment variables to set up: the interpreter\'s executable is a fully bootstrapped and isolated environment.\n\n- A python dockerfile may call `<venv-python-exec>` directly in the dockerfile\'s CMD\n- A service that spawns other processes should receive the path to the `<venv-python-exec>`\n\n[Use the `-m` switch](https://docs.python.org/3/using/cmdline.html#cmdoption-m) in order to launch your app!\n',
    'author': 'Jonathan Piché',
    'author_email': 'tools@coveo.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/coveooss/coveo-python-oss',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6',
}


setup(**setup_kwargs)
