# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-02-12 06:07
from __future__ import unicode_literals

import aldryn_apphooks_config.fields
import app_data.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AnotherExampleConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(max_length=100, verbose_name='type')),
                ('namespace', models.CharField(default=None, max_length=100, unique=True, verbose_name='instance namespace')),
                ('app_data', app_data.fields.AppDataField(default='{}', editable=False)),
                ('max_entries', models.SmallIntegerField(default=5)),
            ],
            options={
                'abstract': False,
                'verbose_name_plural': 'Apphook configs',
                'verbose_name': 'Apphook config',
            },
        ),
        migrations.CreateModel(
            name='Article',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=234, verbose_name='title')),
                ('slug', models.SlugField()),
                ('published', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='ExampleConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(max_length=100, verbose_name='type')),
                ('namespace', models.CharField(default=None, max_length=100, unique=True, verbose_name='instance namespace')),
                ('app_data', app_data.fields.AppDataField(default='{}', editable=False)),
                ('app_title', models.CharField(max_length=234, verbose_name='application title')),
            ],
            options={
                'abstract': False,
                'verbose_name_plural': 'Apphook configs',
                'verbose_name': 'Apphook config',
            },
        ),
        migrations.CreateModel(
            name='NotApphookedModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=234, verbose_name='title')),
            ],
        ),
        migrations.CreateModel(
            name='TranslatableArticle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('section', aldryn_apphooks_config.fields.AppHookConfigField(help_text='When selecting a value, the form is reloaded to get the updated default', on_delete=django.db.models.deletion.CASCADE, to='example.ExampleConfig', verbose_name='section')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TranslatableArticleTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('title', models.CharField(max_length=234, verbose_name='title')),
                ('slug', models.SlugField()),
                ('master', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='example.TranslatableArticle')),
            ],
            options={
                'managed': True,
                'verbose_name': 'translatable article Translation',
                'db_table': 'example_translatablearticle_translation',
                'db_tablespace': '',
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='News',
            fields=[
                ('article_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='example.Article')),
            ],
            bases=('example.article',),
        ),
        migrations.AlterUniqueTogether(
            name='exampleconfig',
            unique_together=set([('type', 'namespace')]),
        ),
        migrations.AddField(
            model_name='article',
            name='section',
            field=aldryn_apphooks_config.fields.AppHookConfigField(help_text='When selecting a value, the form is reloaded to get the updated default', on_delete=django.db.models.deletion.CASCADE, to='example.ExampleConfig', verbose_name='section'),
        ),
        migrations.AlterUniqueTogether(
            name='anotherexampleconfig',
            unique_together=set([('type', 'namespace')]),
        ),
        migrations.AlterUniqueTogether(
            name='translatablearticletranslation',
            unique_together=set([('language_code', 'master')]),
        ),
        migrations.AddField(
            model_name='news',
            name='config',
            field=aldryn_apphooks_config.fields.AppHookConfigField(help_text='When selecting a value, the form is reloaded to get the updated default', on_delete=django.db.models.deletion.CASCADE, to='example.AnotherExampleConfig', verbose_name='config'),
        ),
    ]
