This module by default deploys a configurable Identity Provider with a default Cognito User Pool. These resources can be used by your website to restrict access to only authenticated users if needed. All settings are configurable and the creation of these AuthN resources can be disabled if needed or configured to use custom AuthN providers i.e. Facebook, Google, etc.

Below is a conceptual view of the default architecture this module creates:

```
Cognito User Pool --------------------> Identity Pool
     |_ User Pool Client                     |_ Unauthenticated IAM Role
                                             |_ Authenticated IAM Role
```
# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### UserIdentity <a name="UserIdentity" id="@aws-prototyping-sdk/identity.UserIdentity"></a>

Creates an Identity Pool with sane defaults configured.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer"></a>

```java
import software.aws.awsprototypingsdk.identity.UserIdentity;

UserIdentity.Builder.create(Construct scope, java.lang.String id)
//  .identityPoolOptions(IdentityPoolProps)
//  .userPool(UserPool)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.scope">scope</a></code> | <code>software.constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.identityPoolOptions">identityPoolOptions</a></code> | <code>software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProps</code> | Configuration for the Identity Pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.userPool">userPool</a></code> | <code>software.amazon.awscdk.services.cognito.UserPool</code> | User provided Cognito UserPool. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.scope"></a>

- *Type:* software.constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.id"></a>

- *Type:* java.lang.String

---

##### `identityPoolOptions`<sup>Optional</sup> <a name="identityPoolOptions" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.identityPoolOptions"></a>

- *Type:* software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProps

Configuration for the Identity Pool.

---

##### `userPool`<sup>Optional</sup> <a name="userPool" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.userPool"></a>

- *Type:* software.amazon.awscdk.services.cognito.UserPool
- *Default:* a userpool will be created.

User provided Cognito UserPool.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/identity.UserIdentity.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/identity.UserIdentity.isConstruct"></a>

```java
import software.aws.awsprototypingsdk.identity.UserIdentity;

UserIdentity.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/identity.UserIdentity.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.identityPool">identityPool</a></code> | <code>software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.userPool">userPool</a></code> | <code>software.amazon.awscdk.services.cognito.UserPool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.userPoolClient">userPoolClient</a></code> | <code>software.amazon.awscdk.services.cognito.UserPoolClient</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/identity.UserIdentity.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---

##### `identityPool`<sup>Required</sup> <a name="identityPool" id="@aws-prototyping-sdk/identity.UserIdentity.property.identityPool"></a>

```java
public IdentityPool getIdentityPool();
```

- *Type:* software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPool

---

##### `userPool`<sup>Required</sup> <a name="userPool" id="@aws-prototyping-sdk/identity.UserIdentity.property.userPool"></a>

```java
public UserPool getUserPool();
```

- *Type:* software.amazon.awscdk.services.cognito.UserPool

---

##### `userPoolClient`<sup>Optional</sup> <a name="userPoolClient" id="@aws-prototyping-sdk/identity.UserIdentity.property.userPoolClient"></a>

```java
public UserPoolClient getUserPoolClient();
```

- *Type:* software.amazon.awscdk.services.cognito.UserPoolClient

---


## Structs <a name="Structs" id="Structs"></a>

### UserIdentityProps <a name="UserIdentityProps" id="@aws-prototyping-sdk/identity.UserIdentityProps"></a>

Properties which configures the Identity Pool.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/identity.UserIdentityProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.identity.UserIdentityProps;

UserIdentityProps.builder()
//  .identityPoolOptions(IdentityPoolProps)
//  .userPool(UserPool)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentityProps.property.identityPoolOptions">identityPoolOptions</a></code> | <code>software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProps</code> | Configuration for the Identity Pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentityProps.property.userPool">userPool</a></code> | <code>software.amazon.awscdk.services.cognito.UserPool</code> | User provided Cognito UserPool. |

---

##### `identityPoolOptions`<sup>Optional</sup> <a name="identityPoolOptions" id="@aws-prototyping-sdk/identity.UserIdentityProps.property.identityPoolOptions"></a>

```java
public IdentityPoolProps getIdentityPoolOptions();
```

- *Type:* software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProps

Configuration for the Identity Pool.

---

##### `userPool`<sup>Optional</sup> <a name="userPool" id="@aws-prototyping-sdk/identity.UserIdentityProps.property.userPool"></a>

```java
public UserPool getUserPool();
```

- *Type:* software.amazon.awscdk.services.cognito.UserPool
- *Default:* a userpool will be created.

User provided Cognito UserPool.

---



