This module by default deploys a configurable Identity Provider with a default Cognito User Pool. These resources can be used by your website to restrict access to only authenticated users if needed. All settings are configurable and the creation of these AuthN resources can be disabled if needed or configured to use custom AuthN providers i.e. Facebook, Google, etc.

Below is a conceptual view of the default architecture this module creates:

```
Cognito User Pool --------------------> Identity Pool
     |_ User Pool Client                     |_ Unauthenticated IAM Role
                                             |_ Authenticated IAM Role
```
# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### UserIdentity <a name="UserIdentity" id="@aws-prototyping-sdk/identity.UserIdentity"></a>

Creates an Identity Pool with sane defaults configured.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserIdentity(
  scope: Construct,
  id: str,
  identity_pool_options: IdentityPoolProps = None,
  user_pool: UserPool = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.identityPoolOptions">identity_pool_options</a></code> | <code>aws_cdk.aws_cognito_identitypool_alpha.IdentityPoolProps</code> | Configuration for the Identity Pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.userPool">user_pool</a></code> | <code>aws_cdk.aws_cognito.UserPool</code> | User provided Cognito UserPool. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.id"></a>

- *Type:* str

---

##### `identity_pool_options`<sup>Optional</sup> <a name="identity_pool_options" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.identityPoolOptions"></a>

- *Type:* aws_cdk.aws_cognito_identitypool_alpha.IdentityPoolProps

Configuration for the Identity Pool.

---

##### `user_pool`<sup>Optional</sup> <a name="user_pool" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.userPool"></a>

- *Type:* aws_cdk.aws_cognito.UserPool
- *Default:* a userpool will be created.

User provided Cognito UserPool.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.toString">to_string</a></code> | Returns a string representation of this construct. |

---

##### `to_string` <a name="to_string" id="@aws-prototyping-sdk/identity.UserIdentity.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### `is_construct` <a name="is_construct" id="@aws-prototyping-sdk/identity.UserIdentity.isConstruct"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserIdentity.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/identity.UserIdentity.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.identityPool">identity_pool</a></code> | <code>aws_cdk.aws_cognito_identitypool_alpha.IdentityPool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.userPool">user_pool</a></code> | <code>aws_cdk.aws_cognito.UserPool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.userPoolClient">user_pool_client</a></code> | <code>aws_cdk.aws_cognito.UserPoolClient</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/identity.UserIdentity.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `identity_pool`<sup>Required</sup> <a name="identity_pool" id="@aws-prototyping-sdk/identity.UserIdentity.property.identityPool"></a>

```python
identity_pool: IdentityPool
```

- *Type:* aws_cdk.aws_cognito_identitypool_alpha.IdentityPool

---

##### `user_pool`<sup>Required</sup> <a name="user_pool" id="@aws-prototyping-sdk/identity.UserIdentity.property.userPool"></a>

```python
user_pool: UserPool
```

- *Type:* aws_cdk.aws_cognito.UserPool

---

##### `user_pool_client`<sup>Optional</sup> <a name="user_pool_client" id="@aws-prototyping-sdk/identity.UserIdentity.property.userPoolClient"></a>

```python
user_pool_client: UserPoolClient
```

- *Type:* aws_cdk.aws_cognito.UserPoolClient

---


## Structs <a name="Structs" id="Structs"></a>

### UserIdentityProps <a name="UserIdentityProps" id="@aws-prototyping-sdk/identity.UserIdentityProps"></a>

Properties which configures the Identity Pool.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/identity.UserIdentityProps.Initializer"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserIdentityProps(
  identity_pool_options: IdentityPoolProps = None,
  user_pool: UserPool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentityProps.property.identityPoolOptions">identity_pool_options</a></code> | <code>aws_cdk.aws_cognito_identitypool_alpha.IdentityPoolProps</code> | Configuration for the Identity Pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentityProps.property.userPool">user_pool</a></code> | <code>aws_cdk.aws_cognito.UserPool</code> | User provided Cognito UserPool. |

---

##### `identity_pool_options`<sup>Optional</sup> <a name="identity_pool_options" id="@aws-prototyping-sdk/identity.UserIdentityProps.property.identityPoolOptions"></a>

```python
identity_pool_options: IdentityPoolProps
```

- *Type:* aws_cdk.aws_cognito_identitypool_alpha.IdentityPoolProps

Configuration for the Identity Pool.

---

##### `user_pool`<sup>Optional</sup> <a name="user_pool" id="@aws-prototyping-sdk/identity.UserIdentityProps.property.userPool"></a>

```python
user_pool: UserPool
```

- *Type:* aws_cdk.aws_cognito.UserPool
- *Default:* a userpool will be created.

User provided Cognito UserPool.

---



